/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.results.AbstractContingencyResult;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractContingencyResultDeserializer<T extends AbstractContingencyResult>
extends StdDeserializer<T> {
    protected AbstractContingencyResultDeserializer(Class<T> vc) {
        super(vc);
    }

    protected boolean deserializeCommonAttributes(JsonParser parser, ParsingContext context, String name, DeserializationContext deserializationContext, String version, String contextName) throws IOException {
        switch (name) {
            case "limitViolationsResult": {
                parser.nextToken();
                context.limitViolationsResult = (LimitViolationsResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolationsResult.class);
                return true;
            }
            case "networkResult": {
                parser.nextToken();
                JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)contextName, (String)"Tag: networkResult", (String)version, (String)"1.2");
                context.networkResult = (NetworkResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, NetworkResult.class);
                return true;
            }
            case "busResults": {
                parser.nextToken();
                JsonUtil.assertLessThanOrEqualToReferenceVersion((String)contextName, (String)"Tag: busResults", (String)version, (String)"1.1");
                context.busResults = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, BusResult.class);
                return true;
            }
            case "branchResults": {
                parser.nextToken();
                JsonUtil.assertLessThanOrEqualToReferenceVersion((String)contextName, (String)"Tag: branchResults", (String)version, (String)"1.1");
                context.branchResults = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, BranchResult.class);
                return true;
            }
            case "threeWindingsTransformerResults": {
                parser.nextToken();
                JsonUtil.assertLessThanOrEqualToReferenceVersion((String)contextName, (String)"Tag: threeWindingsTransformerResults", (String)version, (String)"1.1");
                context.threeWindingsTransformerResults = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, ThreeWindingsTransformerResult.class);
                return true;
            }
        }
        return false;
    }

    protected static class ParsingContext {
        LimitViolationsResult limitViolationsResult = null;
        NetworkResult networkResult = null;
        List<BranchResult> branchResults = Collections.emptyList();
        List<BusResult> busResults = Collections.emptyList();
        List<ThreeWindingsTransformerResult> threeWindingsTransformerResults = Collections.emptyList();

        protected ParsingContext() {
        }
    }
}

