/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.extensions.CurrentExtension;
import java.io.IOException;

@AutoService(value={ExtensionJsonSerializer.class})
public class CurrentExtensionSerializer
implements ExtensionJsonSerializer<LimitViolation, CurrentExtension> {
    public String getExtensionName() {
        return "Current";
    }

    public String getCategoryName() {
        return "security-analysis";
    }

    public Class<? super CurrentExtension> getExtensionClass() {
        return CurrentExtension.class;
    }

    public void serialize(CurrentExtension extension, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField("preContingencyValue", extension.getPreContingencyValue());
        jsonGenerator.writeEndObject();
    }

    public CurrentExtension deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        double value = Double.NaN;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentName().equals("preContingencyValue")) {
                parser.nextToken();
                value = (Double)parser.readValueAs(Double.class);
                continue;
            }
            throw new PowsyblException("Unexpected field: " + parser.getCurrentName());
        }
        return new CurrentExtension(value);
    }
}

