/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class LimitViolationDeserializer
extends StdDeserializer<LimitViolation> {
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"security-analysis"));

    public LimitViolationDeserializer() {
        super(LimitViolation.class);
    }

    public LimitViolation deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String subjectId = null;
        String subjectName = null;
        LimitViolationType limitType = null;
        String limitName = null;
        int acceptableDuration = Integer.MAX_VALUE;
        double limit = Double.NaN;
        float limitReduction = Float.NaN;
        double value = Double.NaN;
        ThreeSides side = null;
        List extensions = Collections.emptyList();
        block24: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "subjectId": {
                    subjectId = parser.nextTextValue();
                    continue block24;
                }
                case "subjectName": {
                    subjectName = parser.nextTextValue();
                    continue block24;
                }
                case "limitType": {
                    parser.nextToken();
                    limitType = (LimitViolationType)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolationType.class));
                    continue block24;
                }
                case "limitName": {
                    limitName = parser.nextTextValue();
                    continue block24;
                }
                case "acceptableDuration": {
                    parser.nextToken();
                    acceptableDuration = (Integer)parser.readValueAs(Integer.class);
                    continue block24;
                }
                case "limit": {
                    parser.nextToken();
                    limit = (Double)parser.readValueAs(Double.class);
                    continue block24;
                }
                case "limitReduction": {
                    parser.nextToken();
                    limitReduction = ((Float)parser.readValueAs(Float.class)).floatValue();
                    continue block24;
                }
                case "value": {
                    parser.nextToken();
                    value = (Double)parser.readValueAs(Double.class);
                    continue block24;
                }
                case "side": {
                    parser.nextToken();
                    side = (ThreeSides)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ThreeSides.class);
                    continue block24;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, (ExtensionProviders)((ExtensionProviders)SUPPLIER.get()));
                    continue block24;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        LimitViolation violation = new LimitViolation(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, side);
        ((ExtensionProviders)SUPPLIER.get()).addExtensions((Extendable)violation, extensions);
        return violation;
    }
}

