/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.NetworkMetadata;
import java.io.IOException;
import java.time.format.DateTimeFormatter;

public class NetworkMetadataSerializer
extends StdSerializer<NetworkMetadata> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public NetworkMetadataSerializer() {
        super(NetworkMetadata.class);
    }

    public void serialize(NetworkMetadata networkMetadata, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("id", networkMetadata.getId());
        jsonGenerator.writeStringField("sourceFormat", networkMetadata.getSourceFormat());
        jsonGenerator.writeStringField("caseDate", DATE_TIME_FORMATTER.format(networkMetadata.getCaseDate()));
        jsonGenerator.writeNumberField("forecastDistance", networkMetadata.getForecastDistance());
        JsonUtil.writeExtensions((Extendable)networkMetadata, (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider);
        jsonGenerator.writeEndObject();
    }
}

