/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.security.condition.Condition;
import com.powsybl.security.strategy.ConditionalActions;
import com.powsybl.security.strategy.OperatorStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class OperatorStrategyDeserializer
extends StdDeserializer<OperatorStrategy> {
    private static final String CONTEXT_NAME = "OperatorStrategy";
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"security-analysis"));

    public OperatorStrategyDeserializer() {
        super(OperatorStrategy.class);
    }

    public OperatorStrategy deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        context.version = JsonUtil.getSourceVersion((DatabindContext)deserializationContext, (String)"sourceVersionAttribute");
        if (context.version == null) {
            context.version = "1.5";
        }
        JsonUtil.parseObject((JsonParser)parser, fieldName -> {
            switch (fieldName) {
                case "id": {
                    parser.nextToken();
                    context.id = parser.getValueAsString();
                    return true;
                }
                case "contingencyContextType": {
                    context.contingencyContextType = ContingencyContextType.valueOf((String)parser.nextTextValue());
                    return true;
                }
                case "contingencyId": {
                    parser.nextToken();
                    context.contingencyId = parser.getValueAsString();
                    return true;
                }
                case "conditionalActions": {
                    parser.nextToken();
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: contingencyStatus", (String)context.version, (String)"1.5");
                    context.stages = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, ConditionalActions.class);
                    return true;
                }
                case "condition": {
                    parser.nextToken();
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: contingencyStatus", (String)context.version, (String)"1.4");
                    context.condition = (Condition)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, Condition.class);
                    return true;
                }
                case "actionIds": {
                    parser.nextToken();
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: contingencyStatus", (String)context.version, (String)"1.4");
                    context.actionIds = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, String.class);
                    return true;
                }
                case "extensions": {
                    parser.nextToken();
                    context.extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, (ExtensionProviders)((ExtensionProviders)SUPPLIER.get()));
                    return true;
                }
            }
            return false;
        });
        ContingencyContext contingencyContext = new ContingencyContext(context.contingencyId, context.contingencyContextType != null ? context.contingencyContextType : ContingencyContextType.SPECIFIC);
        OperatorStrategy strategy = context.version.compareTo("1.5") < 0 ? new OperatorStrategy(context.id, contingencyContext, context.condition, context.actionIds) : new OperatorStrategy(context.id, contingencyContext, context.stages);
        ((ExtensionProviders)SUPPLIER.get()).addExtensions((Extendable)strategy, context.extensions);
        return strategy;
    }

    private static class ParsingContext {
        String version;
        String id;
        ContingencyContextType contingencyContextType;
        String contingencyId;
        List<ConditionalActions> stages;
        Condition condition;
        List<String> actionIds;
        List<Extension<OperatorStrategy>> extensions = Collections.emptyList();

        private ParsingContext() {
        }
    }
}

