/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.action;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.security.action.LoadAction;
import java.io.IOException;
import java.io.UncheckedIOException;

public class LoadActionSerializer
extends StdSerializer<LoadAction> {
    public LoadActionSerializer() {
        super(LoadAction.class);
    }

    public void serialize(LoadAction action, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", action.getType());
        jsonGenerator.writeStringField("id", action.getId());
        jsonGenerator.writeStringField("loadId", action.getLoadId());
        jsonGenerator.writeBooleanField("relativeValue", action.isRelativeValue());
        action.getActivePowerValue().ifPresent(activePowerValue -> {
            try {
                jsonGenerator.writeNumberField("activePowerValue", activePowerValue);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        action.getReactivePowerValue().ifPresent(reactivePowerValue -> {
            try {
                jsonGenerator.writeNumberField("reactivePowerValue", reactivePowerValue);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        jsonGenerator.writeEndObject();
    }
}

