/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.action;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.security.action.StaticVarCompensatorAction;
import com.powsybl.security.action.StaticVarCompensatorActionBuilder;
import java.io.IOException;

public class StaticVarCompensatorActionDeserializer
extends StdDeserializer<StaticVarCompensatorAction> {
    public StaticVarCompensatorActionDeserializer() {
        super(StaticVarCompensatorAction.class);
    }

    public StaticVarCompensatorAction deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "type": {
                    if (!"STATIC_VAR_COMPENSATOR".equals(jsonParser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)jsonParser, (String)"Expected type STATIC_VAR_COMPENSATOR");
                    }
                    return true;
                }
                case "id": {
                    context.id = jsonParser.nextTextValue();
                    return true;
                }
                case "staticVarCompensatorId": {
                    context.staticVarCompensatorId = jsonParser.nextTextValue();
                    return true;
                }
                case "regulationMode": {
                    context.regulationMode = jsonParser.nextTextValue();
                    return true;
                }
                case "voltageSetpoint": {
                    jsonParser.nextToken();
                    context.voltageSetpoint = jsonParser.getValueAsDouble();
                    return true;
                }
                case "reactivePowerSetpoint": {
                    jsonParser.nextToken();
                    context.reactivePowerSetpoint = jsonParser.getValueAsDouble();
                    return true;
                }
            }
            return false;
        });
        StaticVarCompensatorActionBuilder builder = new StaticVarCompensatorActionBuilder();
        builder.withId(context.id).withStaticVarCompensatorId(context.staticVarCompensatorId);
        if (context.regulationMode != null) {
            builder.withRegulationMode(StaticVarCompensator.RegulationMode.valueOf((String)context.regulationMode));
        }
        if (context.voltageSetpoint != null) {
            builder.withVoltageSetpoint(context.voltageSetpoint);
        }
        if (context.reactivePowerSetpoint != null) {
            builder.withReactivePowerSetpoint(context.reactivePowerSetpoint);
        }
        return builder.build();
    }

    private static class ParsingContext {
        String id;
        String staticVarCompensatorId;
        String regulationMode;
        Double voltageSetpoint;
        Double reactivePowerSetpoint;

        private ParsingContext() {
        }
    }
}

