/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.strategy;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.security.condition.Condition;
import com.powsybl.security.strategy.ConditionalActions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class OperatorStrategy
extends AbstractExtendable<OperatorStrategy> {
    private final String id;
    private final ContingencyContext contingencyContext;
    private final List<ConditionalActions> conditionalActions;

    public OperatorStrategy(String id, ContingencyContext contingencyContext, Condition condition, List<String> actionIds) {
        this.id = Objects.requireNonNull(id);
        this.contingencyContext = Objects.requireNonNull(contingencyContext);
        this.conditionalActions = List.of(new ConditionalActions("default", condition, actionIds));
    }

    public OperatorStrategy(String id, ContingencyContext contingencyContext, List<ConditionalActions> stages) {
        this.id = Objects.requireNonNull(id);
        this.contingencyContext = Objects.requireNonNull(contingencyContext);
        this.conditionalActions = List.copyOf((Collection)Objects.requireNonNull(stages));
    }

    public String getId() {
        return this.id;
    }

    public ContingencyContext getContingencyContext() {
        return this.contingencyContext;
    }

    public List<ConditionalActions> getConditionalActions() {
        return this.conditionalActions;
    }
}

