/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.security.LimitViolationType;
import java.util.Objects;
import javax.annotation.Nullable;

public class LimitViolation
extends AbstractExtendable<LimitViolation> {
    private final String subjectId;
    private final String subjectName;
    private final LimitViolationType limitType;
    private final double limit;
    private final String limitName;
    private final int acceptableDuration;
    private final float limitReduction;
    private final double value;
    private final ThreeSides side;

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, float limitReduction, double value, @Nullable ThreeSides side) {
        this.subjectId = Objects.requireNonNull(subjectId);
        this.subjectName = subjectName;
        this.limitType = Objects.requireNonNull(limitType);
        this.limitName = limitName;
        this.acceptableDuration = acceptableDuration;
        this.limit = limit;
        this.limitReduction = limitReduction;
        this.value = value;
        this.side = LimitViolation.checkSide(limitType, side);
    }

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, float limitReduction, double value) {
        this(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, (ThreeSides)null);
    }

    public LimitViolation(String subjectId, @Nullable String subjectName, LimitViolationType limitType, @Nullable String limitName, int acceptableDuration, double limit, float limitReduction, double value, TwoSides side) {
        this(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, Objects.requireNonNull(side).toThreeSides());
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, String limitName, int acceptableDuration, double limit, float limitReduction, double value, TwoSides side) {
        this(subjectId, null, limitType, limitName, acceptableDuration, limit, limitReduction, value, Objects.requireNonNull(side).toThreeSides());
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, String limitName, int acceptableDuration, double limit, float limitReduction, double value) {
        this(subjectId, null, limitType, limitName, acceptableDuration, limit, limitReduction, value, (ThreeSides)null);
    }

    public LimitViolation(String subjectId, String subjectName, LimitViolationType limitType, double limit, float limitReduction, double value) {
        this(subjectId, subjectName, limitType, null, Integer.MAX_VALUE, limit, limitReduction, value, (ThreeSides)null);
    }

    public LimitViolation(String subjectId, LimitViolationType limitType, double limit, float limitReduction, double value) {
        this(subjectId, null, limitType, null, Integer.MAX_VALUE, limit, limitReduction, value, (ThreeSides)null);
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    @Nullable
    public String getSubjectName() {
        return this.subjectName;
    }

    public LimitViolationType getLimitType() {
        return this.limitType;
    }

    public double getLimit() {
        return this.limit;
    }

    @Nullable
    public String getLimitName() {
        return this.limitName;
    }

    public int getAcceptableDuration() {
        return this.acceptableDuration;
    }

    public float getLimitReduction() {
        return this.limitReduction;
    }

    public double getValue() {
        return this.value;
    }

    public TwoSides getSideAsTwoSides() {
        return Objects.requireNonNull(this.side).toTwoSides();
    }

    @Nullable
    public ThreeSides getSide() {
        return this.side;
    }

    private static ThreeSides checkSide(LimitViolationType limitType, ThreeSides side) {
        if (limitType == LimitViolationType.ACTIVE_POWER || limitType == LimitViolationType.APPARENT_POWER || limitType == LimitViolationType.CURRENT) {
            return Objects.requireNonNull(side);
        }
        return null;
    }

    public String toString() {
        return "Subject id: " + this.subjectId + ", Subject name: " + this.subjectName + ", limitType: " + this.limitType + ", limit: " + this.limit + ", limitName: " + this.limitName + ", acceptableDuration: " + this.acceptableDuration + ", limitReduction: " + this.limitReduction + ", value: " + this.value + ", side: " + this.side;
    }
}

