/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.google.common.collect.Lists;
import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationDetector;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.action.Action;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;

public interface SecurityAnalysisProvider
extends Versionable,
PlatformConfigNamedProvider {
    public static List<SecurityAnalysisProvider> findAll() {
        return Lists.newArrayList(ServiceLoader.load(SecurityAnalysisProvider.class, SecurityAnalysisProvider.class.getClassLoader()));
    }

    public CompletableFuture<SecurityAnalysisReport> run(Network var1, String var2, LimitViolationDetector var3, LimitViolationFilter var4, ComputationManager var5, SecurityAnalysisParameters var6, ContingenciesProvider var7, List<SecurityAnalysisInterceptor> var8, List<OperatorStrategy> var9, List<Action> var10, List<StateMonitor> var11, Reporter var12);

    default public Optional<ExtensionJsonSerializer> getSpecificParametersSerializer() {
        return Optional.empty();
    }

    default public Optional<Extension<SecurityAnalysisParameters>> loadSpecificParameters(PlatformConfig config) {
        return Optional.empty();
    }

    default public Optional<Extension<SecurityAnalysisParameters>> loadSpecificParameters(Map<String, String> properties) {
        return Optional.empty();
    }

    default public void updateSpecificParameters(Extension<SecurityAnalysisParameters> extension, Map<String, String> properties) {
    }

    default public Optional<String> getLoadFlowProviderName() {
        return Optional.empty();
    }

    default public List<String> getSpecificParametersNames() {
        return Collections.emptyList();
    }
}

