/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.comparator;

import com.google.auto.service.AutoService;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.comparator.SecurityAnalysisResultEquivalence;
import com.powsybl.security.json.SecurityAnalysisResultDeserializer;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolRunningContext;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@AutoService(value={Tool.class})
public class CompareSecurityAnalysisResultsTool
implements Tool {
    private static final String RESULT1_FILE_OPTION = "result1-file";
    private static final String RESULT2_FILE_OPTION = "result2-file";
    private static final String OUTPUT_FILE_OPTION = "output-file";
    private static final String THRESHOLD_OPTION = "threshold";
    private static final double THRESHOLD_DEFAULT = 0.0;

    public Command getCommand() {
        return new Command(){

            public String getName() {
                return "compare-security-analysis-results";
            }

            public String getTheme() {
                return "Computation";
            }

            public String getDescription() {
                return "Compare security analysis results";
            }

            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt(CompareSecurityAnalysisResultsTool.RESULT1_FILE_OPTION).desc("security analysis result 1 file path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(CompareSecurityAnalysisResultsTool.RESULT2_FILE_OPTION).desc("security analysis result 2 file path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(CompareSecurityAnalysisResultsTool.OUTPUT_FILE_OPTION).desc("output file path, where the comparison results will be stored").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(CompareSecurityAnalysisResultsTool.THRESHOLD_OPTION).desc("threshold used for results comparison, default is 0.0").hasArg().argName("THRESHOLD").build());
                return options;
            }

            public String getUsageFooter() {
                return null;
            }
        };
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        Path results1File = context.getFileSystem().getPath(line.getOptionValue(RESULT1_FILE_OPTION), new String[0]);
        Path results2File = context.getFileSystem().getPath(line.getOptionValue(RESULT2_FILE_OPTION), new String[0]);
        Path outputFile = context.getFileSystem().getPath(line.getOptionValue(OUTPUT_FILE_OPTION), new String[0]);
        double threshold = line.hasOption(THRESHOLD_OPTION) ? Double.parseDouble(line.getOptionValue(THRESHOLD_OPTION)) : 0.0;
        try (BufferedWriter outputWriter = Files.newBufferedWriter(outputFile, new OpenOption[0]);){
            SecurityAnalysisResult result1 = SecurityAnalysisResultDeserializer.read(results1File);
            SecurityAnalysisResult result2 = SecurityAnalysisResultDeserializer.read(results2File);
            SecurityAnalysisResultEquivalence resultEquivalence = new SecurityAnalysisResultEquivalence(threshold, outputWriter);
            context.getOutputStream().println("Comparison result: " + (resultEquivalence.equivalent((Object)result1, (Object)result2) ? "success" : "fail"));
        }
    }
}

