/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.comparator;

import com.google.common.base.Equivalence;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.comparator.LimitViolationComparator;
import com.powsybl.security.comparator.LimitViolationEquivalence;
import com.powsybl.security.comparator.SecurityAnalysisResultComparisonWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LimitViolationsResultEquivalence
extends Equivalence<LimitViolationsResult> {
    private final double threshold;
    private SecurityAnalysisResultComparisonWriter comparisonWriter;

    public LimitViolationsResultEquivalence(double threshold, Writer writer) {
        this(threshold, new SecurityAnalysisResultComparisonWriter(writer));
    }

    LimitViolationsResultEquivalence(double threshold, SecurityAnalysisResultComparisonWriter comparisonWriter) {
        this.threshold = threshold;
        this.comparisonWriter = comparisonWriter;
    }

    protected boolean doEquivalent(LimitViolationsResult result1, LimitViolationsResult result2) {
        LimitViolation violation1;
        LimitViolationComparator violationComparator = new LimitViolationComparator();
        LimitViolationEquivalence violationEquivalence = new LimitViolationEquivalence(this.threshold);
        boolean equivalent = true;
        List<LimitViolation> violations1 = result1.getLimitViolations();
        List<LimitViolation> violations2 = result2.getLimitViolations();
        Collections.sort(violations1, violationComparator);
        Collections.sort(violations2, violationComparator);
        int index1 = 0;
        int index2 = 0;
        while (index1 < violations1.size() && index2 < violations2.size()) {
            LimitViolation violation2;
            violation1 = violations1.get(index1);
            int violationsComparison = violationComparator.compare(violation1, violation2 = violations2.get(index2));
            if (violationsComparison == 0) {
                boolean violationsEquivalent = violationEquivalence.equivalent((Object)violation1, (Object)violation2);
                this.comparisonWriter.write(violation1, violation2, violationsEquivalent);
                equivalent &= violationsEquivalent;
                ++index1;
                ++index2;
                continue;
            }
            if (violationsComparison < 0) {
                equivalent &= this.isSmallViolation(violation1, false);
                ++index1;
                continue;
            }
            equivalent &= this.isSmallViolation(violation2, true);
            ++index2;
        }
        while (index1 < violations1.size()) {
            violation1 = violations1.get(index1);
            equivalent &= this.isSmallViolation(violation1, false);
            ++index1;
        }
        while (index2 < violations2.size()) {
            LimitViolation violation2 = violations2.get(index1);
            equivalent &= this.isSmallViolation(violation2, true);
            ++index2;
        }
        List<String> actions1 = result1.getActionsTaken();
        List<String> actions2 = result2.getActionsTaken();
        Collections.sort(actions1);
        Collections.sort(actions2);
        boolean actionsEquivalent = actions1.equals(actions2);
        this.comparisonWriter.write(actions1, actions2, actionsEquivalent);
        return equivalent &= actionsEquivalent;
    }

    private boolean isSmallViolation(LimitViolation violation, boolean missingResult1) {
        boolean smallViolation = Math.abs(violation.getValue() - violation.getLimit() * (double)violation.getLimitReduction()) <= this.threshold;
        this.comparisonWriter = missingResult1 ? this.comparisonWriter.write(null, violation, smallViolation) : this.comparisonWriter.write(violation, null, smallViolation);
        return smallViolation;
    }

    protected int doHash(LimitViolationsResult result) {
        return Objects.hashCode(result);
    }
}

