/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.security.SecurityAnalysis;
import com.powsybl.security.SecurityAnalysisInput;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import com.powsybl.security.execution.SecurityAnalysisInputBuildStrategy;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class SecurityAnalysisExecutionImpl
implements SecurityAnalysisExecution {
    private final SecurityAnalysis.Runner runner;
    private final SecurityAnalysisInputBuildStrategy inputBuildStrategy;

    public SecurityAnalysisExecutionImpl() {
        this(null, SecurityAnalysisExecutionImpl::buildDefault);
    }

    public SecurityAnalysisExecutionImpl(SecurityAnalysis.Runner runner) {
        this(runner, SecurityAnalysisExecutionImpl::buildDefault);
    }

    public SecurityAnalysisExecutionImpl(SecurityAnalysis.Runner runner, SecurityAnalysisInputBuildStrategy inputBuildStrategy) {
        this.runner = Objects.requireNonNull(runner);
        this.inputBuildStrategy = Objects.requireNonNull(inputBuildStrategy);
    }

    private static SecurityAnalysisInput buildDefault(SecurityAnalysisExecutionInput executionInput) {
        return new SecurityAnalysisInput(executionInput.getNetworkVariant());
    }

    private SecurityAnalysisInput buildInput(SecurityAnalysisExecutionInput executionInput) {
        return this.inputBuildStrategy.buildFrom(executionInput);
    }

    @Override
    public CompletableFuture<SecurityAnalysisReport> execute(ComputationManager computationManager, SecurityAnalysisExecutionInput data) {
        SecurityAnalysisInput input = this.buildInput(data);
        return this.runner.runAsync(input.getNetworkVariant().getNetwork(), input.getNetworkVariant().getVariantId(), input.getContingenciesProvider(), input.getParameters(), computationManager, input.getFilter(), input.getLimitViolationDetector(), new ArrayList<SecurityAnalysisInterceptor>(input.getInterceptors()), data.getOperatorStrategies(), data.getActions(), data.getMonitors(), Reporter.NO_OP);
    }
}

