/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.google.common.io.ByteSource;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.action.Action;
import com.powsybl.security.execution.NetworkVariant;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SecurityAnalysisExecutionInput {
    private NetworkVariant networkVariant;
    private ByteSource contingenciesSource;
    private SecurityAnalysisParameters parameters;
    private final List<String> resultExtensions = new ArrayList<String>();
    private final Set<LimitViolationType> violationTypes = EnumSet.noneOf(LimitViolationType.class);
    private boolean withLogs = false;
    private final List<OperatorStrategy> operatorStrategies = new ArrayList<OperatorStrategy>();
    private final List<Action> actions = new ArrayList<Action>();
    private final List<StateMonitor> monitors = new ArrayList<StateMonitor>();

    public Optional<ByteSource> getContingenciesSource() {
        return Optional.ofNullable(this.contingenciesSource);
    }

    public List<String> getResultExtensions() {
        return Collections.unmodifiableList(this.resultExtensions);
    }

    public Set<LimitViolationType> getViolationTypes() {
        return Collections.unmodifiableSet(this.violationTypes);
    }

    public SecurityAnalysisParameters getParameters() {
        return this.parameters;
    }

    public NetworkVariant getNetworkVariant() {
        return this.networkVariant;
    }

    public List<OperatorStrategy> getOperatorStrategies() {
        return Collections.unmodifiableList(this.operatorStrategies);
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public List<StateMonitor> getMonitors() {
        return Collections.unmodifiableList(this.monitors);
    }

    public boolean isWithLogs() {
        return this.withLogs;
    }

    public SecurityAnalysisExecutionInput setContingenciesSource(ByteSource contingenciesSource) {
        this.contingenciesSource = contingenciesSource;
        return this;
    }

    public SecurityAnalysisExecutionInput addResultExtension(String resultExtension) {
        this.resultExtensions.add(Objects.requireNonNull(resultExtension));
        return this;
    }

    public SecurityAnalysisExecutionInput addResultExtensions(Collection<String> resultExtensions) {
        this.resultExtensions.addAll(Objects.requireNonNull(resultExtensions));
        return this;
    }

    public SecurityAnalysisExecutionInput addViolationType(LimitViolationType violationType) {
        this.violationTypes.add(Objects.requireNonNull(violationType));
        return this;
    }

    public SecurityAnalysisExecutionInput addViolationTypes(Collection<LimitViolationType> violationTypes) {
        this.violationTypes.addAll(Objects.requireNonNull(violationTypes));
        return this;
    }

    public SecurityAnalysisExecutionInput addOperatorStrategies(List<OperatorStrategy> operatorStrategies) {
        this.operatorStrategies.addAll((Collection<OperatorStrategy>)Objects.requireNonNull(operatorStrategies));
        return this;
    }

    public SecurityAnalysisExecutionInput addActions(List<Action> actions) {
        this.actions.addAll((Collection<Action>)Objects.requireNonNull(actions));
        return this;
    }

    public SecurityAnalysisExecutionInput setParameters(SecurityAnalysisParameters parameters) {
        this.parameters = Objects.requireNonNull(parameters);
        return this;
    }

    public SecurityAnalysisExecutionInput setNetworkVariant(Network network, String variantId) {
        this.networkVariant = new NetworkVariant(network, variantId);
        return this;
    }

    public SecurityAnalysisExecutionInput setOperatorStrategies(List<OperatorStrategy> operatorStrategies) {
        Objects.requireNonNull(operatorStrategies);
        this.operatorStrategies.clear();
        this.operatorStrategies.addAll(operatorStrategies);
        return this;
    }

    public SecurityAnalysisExecutionInput setActions(List<Action> actions) {
        Objects.requireNonNull(actions);
        this.actions.clear();
        this.actions.addAll(actions);
        return this;
    }

    public SecurityAnalysisExecutionInput setMonitors(List<StateMonitor> monitors) {
        Objects.requireNonNull(monitors);
        this.monitors.clear();
        this.monitors.addAll(monitors);
        return this;
    }

    public SecurityAnalysisExecutionInput setWithLogs(boolean withLogs) {
        this.withLogs = withLogs;
        return this;
    }
}

