/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.results.ConnectivityResult;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class ConnectivityResultDeserializer
extends StdDeserializer<ConnectivityResult> {
    public ConnectivityResultDeserializer() {
        super(ConnectivityResult.class);
    }

    public ConnectivityResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        int createdSynchronousComponentCount = 0;
        int createdConnectedComponentCount = 0;
        double disconnectedLoadActivePower = 0.0;
        double disconnectedGenerationActivePower = 0.0;
        Set disconnectedElements = Collections.emptySet();
        block14: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "createdSynchronousComponentCount": {
                    parser.nextToken();
                    createdSynchronousComponentCount = parser.getIntValue();
                    continue block14;
                }
                case "createdConnectedComponentCount": {
                    parser.nextToken();
                    createdConnectedComponentCount = parser.getIntValue();
                    continue block14;
                }
                case "disconnectedLoadActivePower": {
                    parser.nextToken();
                    disconnectedLoadActivePower = parser.getDoubleValue();
                    continue block14;
                }
                case "disconnectedGenerationActivePower": {
                    parser.nextToken();
                    disconnectedGenerationActivePower = parser.getDoubleValue();
                    continue block14;
                }
                case "disconnectedElements": {
                    parser.nextToken();
                    disconnectedElements = JsonUtil.readSet((DeserializationContext)deserializationContext, (JsonParser)parser, String.class);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        return new ConnectivityResult(createdSynchronousComponentCount, createdConnectedComponentCount, disconnectedLoadActivePower, disconnectedGenerationActivePower, disconnectedElements);
    }
}

