/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.contingency.json.ContingencyJsonModule;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.NetworkMetadata;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.action.Action;
import com.powsybl.security.action.ActionList;
import com.powsybl.security.action.GeneratorAction;
import com.powsybl.security.action.HvdcAction;
import com.powsybl.security.action.LoadAction;
import com.powsybl.security.action.MultipleActionsAction;
import com.powsybl.security.action.PhaseTapChangerRegulationAction;
import com.powsybl.security.action.PhaseTapChangerTapPositionAction;
import com.powsybl.security.action.RatioTapChangerRegulationAction;
import com.powsybl.security.action.RatioTapChangerTapPositionAction;
import com.powsybl.security.action.ShuntCompensatorPositionAction;
import com.powsybl.security.action.StaticVarCompensatorAction;
import com.powsybl.security.action.SwitchAction;
import com.powsybl.security.action.TerminalsConnectionAction;
import com.powsybl.security.condition.Condition;
import com.powsybl.security.json.BranchResultDeserializer;
import com.powsybl.security.json.BranchResultSerializer;
import com.powsybl.security.json.BusResultDeserializer;
import com.powsybl.security.json.BusResultSerializer;
import com.powsybl.security.json.ConditionDeserializer;
import com.powsybl.security.json.ConditionSerializer;
import com.powsybl.security.json.ConditionalActionsDeserializer;
import com.powsybl.security.json.ConditionalActionsSerializer;
import com.powsybl.security.json.ConnectivityResultDeserializer;
import com.powsybl.security.json.ConnectivityResultSerializer;
import com.powsybl.security.json.LimitViolationDeserializer;
import com.powsybl.security.json.LimitViolationResultDeserializer;
import com.powsybl.security.json.LimitViolationSerializer;
import com.powsybl.security.json.LimitViolationsResultSerializer;
import com.powsybl.security.json.NetworkMetadataDeserializer;
import com.powsybl.security.json.NetworkMetadataSerializer;
import com.powsybl.security.json.NetworkResultDeserializer;
import com.powsybl.security.json.OperatorStrategyDeserializer;
import com.powsybl.security.json.OperatorStrategyListDeserializer;
import com.powsybl.security.json.OperatorStrategyListSerializer;
import com.powsybl.security.json.OperatorStrategyResultDeserializer;
import com.powsybl.security.json.OperatorStrategyResultSerializer;
import com.powsybl.security.json.OperatorStrategySerializer;
import com.powsybl.security.json.PostContingencyResultDeserializer;
import com.powsybl.security.json.PostContingencyResultSerializer;
import com.powsybl.security.json.PreContingencyResultDeserializer;
import com.powsybl.security.json.PreContingencyResultSerializer;
import com.powsybl.security.json.SecurityAnalysisJsonPlugin;
import com.powsybl.security.json.SecurityAnalysisParametersDeserializer;
import com.powsybl.security.json.SecurityAnalysisParametersSerializer;
import com.powsybl.security.json.SecurityAnalysisResultDeserializer;
import com.powsybl.security.json.SecurityAnalysisResultSerializer;
import com.powsybl.security.json.ThreeWindingsTransformerResultDeserializer;
import com.powsybl.security.json.ThreeWindingsTransformerResultSerializer;
import com.powsybl.security.json.action.ActionListDeserializer;
import com.powsybl.security.json.action.ActionListSerializer;
import com.powsybl.security.json.action.GeneratorActionDeserializer;
import com.powsybl.security.json.action.GeneratorActionSerializer;
import com.powsybl.security.json.action.HvdcActionDeserializer;
import com.powsybl.security.json.action.HvdcActionSerializer;
import com.powsybl.security.json.action.LoadActionDeserializer;
import com.powsybl.security.json.action.LoadActionSerializer;
import com.powsybl.security.json.action.MultipleActionsActionDeserializer;
import com.powsybl.security.json.action.MultipleActionsActionSerializer;
import com.powsybl.security.json.action.PhaseTapChangerRegulationActionDeserializer;
import com.powsybl.security.json.action.PhaseTapChangerRegulationActionSerializer;
import com.powsybl.security.json.action.PhaseTapChangerTapPositionActionDeserializer;
import com.powsybl.security.json.action.PhaseTapChangerTapPositionActionSerializer;
import com.powsybl.security.json.action.RatioTapChangerRegulationActionDeserializer;
import com.powsybl.security.json.action.RatioTapChangerRegulationActionSerializer;
import com.powsybl.security.json.action.RatioTapChangerTapPositionActionDeserializer;
import com.powsybl.security.json.action.RatioTapChangerTapPositionActionSerializer;
import com.powsybl.security.json.action.ShuntCompensatorPositionActionDeserializer;
import com.powsybl.security.json.action.ShuntCompensatorPositionActionSerializer;
import com.powsybl.security.json.action.StaticVarCompensatorActionDeserializer;
import com.powsybl.security.json.action.StaticVarCompensatorActionSerializer;
import com.powsybl.security.json.action.SwitchActionDeserializer;
import com.powsybl.security.json.action.SwitchActionSerializer;
import com.powsybl.security.json.action.TerminalsConnectionActionDeserializer;
import com.powsybl.security.json.action.TerminalsConnectionActionSerializer;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import com.powsybl.security.strategy.ConditionalActions;
import com.powsybl.security.strategy.OperatorStrategy;
import com.powsybl.security.strategy.OperatorStrategyList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SecurityAnalysisJsonModule
extends ContingencyJsonModule {
    private final List<SecurityAnalysisJsonPlugin> plugins;

    public SecurityAnalysisJsonModule() {
        this(SecurityAnalysisJsonModule.getServices());
    }

    private static List<SecurityAnalysisJsonPlugin> getServices() {
        return new ServiceLoaderCache(SecurityAnalysisJsonPlugin.class).getServices();
    }

    public SecurityAnalysisJsonModule(Collection<SecurityAnalysisJsonPlugin> plugins) {
        Objects.requireNonNull(plugins);
        this.plugins = List.copyOf(plugins);
        this.addSerializer(SecurityAnalysisResult.class, (JsonSerializer)new SecurityAnalysisResultSerializer());
        this.addSerializer(NetworkMetadata.class, (JsonSerializer)new NetworkMetadataSerializer());
        this.addSerializer(PostContingencyResult.class, (JsonSerializer)new PostContingencyResultSerializer());
        this.addSerializer(LimitViolationsResult.class, (JsonSerializer)new LimitViolationsResultSerializer());
        this.addSerializer(LimitViolation.class, (JsonSerializer)new LimitViolationSerializer());
        this.addSerializer(PreContingencyResult.class, (JsonSerializer)new PreContingencyResultSerializer());
        this.addSerializer(BusResult.class, (JsonSerializer)new BusResultSerializer());
        this.addSerializer(BranchResult.class, (JsonSerializer)new BranchResultSerializer());
        this.addSerializer(ThreeWindingsTransformerResult.class, (JsonSerializer)new ThreeWindingsTransformerResultSerializer());
        this.addSerializer(SecurityAnalysisParameters.class, (JsonSerializer)new SecurityAnalysisParametersSerializer());
        this.addSerializer(OperatorStrategyResult.class, (JsonSerializer)new OperatorStrategyResultSerializer());
        this.addSerializer(OperatorStrategy.class, (JsonSerializer)new OperatorStrategySerializer());
        this.addSerializer(OperatorStrategyList.class, (JsonSerializer)new OperatorStrategyListSerializer());
        this.addSerializer(ConditionalActions.class, (JsonSerializer)new ConditionalActionsSerializer());
        this.addSerializer(ActionList.class, (JsonSerializer)new ActionListSerializer());
        this.addSerializer(Condition.class, (JsonSerializer)new ConditionSerializer());
        this.addSerializer(ConnectivityResult.class, (JsonSerializer)new ConnectivityResultSerializer());
        this.addDeserializer(SecurityAnalysisResult.class, (JsonDeserializer)new SecurityAnalysisResultDeserializer());
        this.addDeserializer(NetworkMetadata.class, (JsonDeserializer)new NetworkMetadataDeserializer());
        this.addDeserializer(PostContingencyResult.class, (JsonDeserializer)new PostContingencyResultDeserializer());
        this.addDeserializer(LimitViolationsResult.class, (JsonDeserializer)new LimitViolationResultDeserializer());
        this.addDeserializer(LimitViolation.class, (JsonDeserializer)new LimitViolationDeserializer());
        this.addDeserializer(PreContingencyResult.class, (JsonDeserializer)new PreContingencyResultDeserializer());
        this.addDeserializer(BusResult.class, (JsonDeserializer)new BusResultDeserializer());
        this.addDeserializer(BranchResult.class, (JsonDeserializer)new BranchResultDeserializer());
        this.addDeserializer(ThreeWindingsTransformerResult.class, (JsonDeserializer)new ThreeWindingsTransformerResultDeserializer());
        this.addDeserializer(SecurityAnalysisParameters.class, (JsonDeserializer)new SecurityAnalysisParametersDeserializer());
        this.addDeserializer(OperatorStrategyResult.class, (JsonDeserializer)new OperatorStrategyResultDeserializer());
        this.addDeserializer(OperatorStrategy.class, (JsonDeserializer)new OperatorStrategyDeserializer());
        this.addDeserializer(OperatorStrategyList.class, (JsonDeserializer)new OperatorStrategyListDeserializer());
        this.addDeserializer(ConditionalActions.class, (JsonDeserializer)new ConditionalActionsDeserializer());
        this.addDeserializer(ActionList.class, (JsonDeserializer)new ActionListDeserializer());
        this.addDeserializer(Condition.class, (JsonDeserializer)new ConditionDeserializer());
        this.addDeserializer(NetworkResult.class, (JsonDeserializer)new NetworkResultDeserializer());
        this.addDeserializer(ConnectivityResult.class, (JsonDeserializer)new ConnectivityResultDeserializer());
        this.configureActionsSerialization();
    }

    private void configureActionsSerialization() {
        this.setMixInAnnotation(Action.class, ActionMixIn.class);
        this.registerActionType((Class)SwitchAction.class, "SWITCH", (JsonSerializer)new SwitchActionSerializer(), (JsonDeserializer)new SwitchActionDeserializer());
        this.registerActionType((Class)TerminalsConnectionAction.class, "TERMINALS_CONNECTION", (JsonSerializer)new TerminalsConnectionActionSerializer(), (JsonDeserializer)new TerminalsConnectionActionDeserializer());
        this.registerActionType((Class)MultipleActionsAction.class, "MULTIPLE_ACTIONS", (JsonSerializer)new MultipleActionsActionSerializer(), (JsonDeserializer)new MultipleActionsActionDeserializer());
        this.registerActionType((Class)PhaseTapChangerTapPositionAction.class, "PHASE_TAP_CHANGER_TAP_POSITION", (JsonSerializer)new PhaseTapChangerTapPositionActionSerializer(), (JsonDeserializer)new PhaseTapChangerTapPositionActionDeserializer());
        this.registerActionType((Class)RatioTapChangerTapPositionAction.class, "RATIO_TAP_CHANGER_TAP_POSITION", (JsonSerializer)new RatioTapChangerTapPositionActionSerializer(), (JsonDeserializer)new RatioTapChangerTapPositionActionDeserializer());
        this.registerActionType((Class)PhaseTapChangerRegulationAction.class, "PHASE_TAP_CHANGER_REGULATION", (JsonSerializer)new PhaseTapChangerRegulationActionSerializer(), (JsonDeserializer)new PhaseTapChangerRegulationActionDeserializer());
        this.registerActionType((Class)RatioTapChangerRegulationAction.class, "RATIO_TAP_CHANGER_REGULATION", (JsonSerializer)new RatioTapChangerRegulationActionSerializer(), (JsonDeserializer)new RatioTapChangerRegulationActionDeserializer());
        this.registerActionType((Class)LoadAction.class, "LOAD", (JsonSerializer)new LoadActionSerializer(), (JsonDeserializer)new LoadActionDeserializer());
        this.registerActionType((Class)HvdcAction.class, "HVDC", (JsonSerializer)new HvdcActionSerializer(), (JsonDeserializer)new HvdcActionDeserializer());
        this.registerActionType((Class)GeneratorAction.class, "GENERATOR", (JsonSerializer)new GeneratorActionSerializer(), (JsonDeserializer)new GeneratorActionDeserializer());
        this.registerActionType((Class)ShuntCompensatorPositionAction.class, "SHUNT_COMPENSATOR_POSITION", (JsonSerializer)new ShuntCompensatorPositionActionSerializer(), (JsonDeserializer)new ShuntCompensatorPositionActionDeserializer());
        this.registerActionType((Class)StaticVarCompensatorAction.class, "STATIC_VAR_COMPENSATOR", (JsonSerializer)new StaticVarCompensatorActionSerializer(), (JsonDeserializer)new StaticVarCompensatorActionDeserializer());
    }

    private <T> void registerActionType(Class<T> actionClass, String typeName, JsonSerializer<T> serializer, JsonDeserializer<T> deserializer) {
        this.registerSubtypes(new NamedType[]{new NamedType(actionClass, typeName)});
        this.addDeserializer(actionClass, deserializer);
        this.addSerializer(actionClass, serializer);
    }

    public Iterable<? extends Module> getDependencies() {
        return () -> this.plugins.stream().flatMap(plugin -> plugin.getJsonModules().stream()).iterator();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true)
    static interface ActionMixIn {
    }
}

