/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.json.SecurityAnalysisJsonModule;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class SecurityAnalysisResultSerializer
extends StdSerializer<SecurityAnalysisResult> {
    public static final String VERSION = "1.5";

    SecurityAnalysisResultSerializer() {
        super(SecurityAnalysisResult.class);
    }

    public void serialize(SecurityAnalysisResult result, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("version", VERSION);
        if (result.getNetworkMetadata() != null) {
            serializerProvider.defaultSerializeField("network", (Object)result.getNetworkMetadata(), jsonGenerator);
        }
        serializerProvider.defaultSerializeField("preContingencyResult", (Object)result.getPreContingencyResult(), jsonGenerator);
        serializerProvider.defaultSerializeField("postContingencyResults", result.getPostContingencyResults(), jsonGenerator);
        serializerProvider.defaultSerializeField("operatorStrategyResults", result.getOperatorStrategyResults(), jsonGenerator);
        JsonUtil.writeExtensions((Extendable)result, (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider);
        jsonGenerator.writeEndObject();
    }

    public static void write(SecurityAnalysisResult result, Writer writer) throws IOException {
        Objects.requireNonNull(result);
        Objects.requireNonNull(writer);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper().registerModule((Module)new SecurityAnalysisJsonModule());
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        objectWriter.writeValue(writer, (Object)result);
    }
}

