/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.action;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.security.action.GeneratorAction;
import java.io.IOException;
import java.io.UncheckedIOException;

public class GeneratorActionSerializer
extends StdSerializer<GeneratorAction> {
    public GeneratorActionSerializer() {
        super(GeneratorAction.class);
    }

    public void serialize(GeneratorAction action, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", action.getType());
        jsonGenerator.writeStringField("id", action.getId());
        jsonGenerator.writeStringField("generatorId", action.getGeneratorId());
        action.isActivePowerRelativeValue().ifPresent(activePowerRelativeValue -> {
            try {
                jsonGenerator.writeBooleanField("activePowerRelativeValue", activePowerRelativeValue.booleanValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        action.getActivePowerValue().ifPresent(activePowerValue -> {
            try {
                jsonGenerator.writeNumberField("activePowerValue", activePowerValue);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        action.isVoltageRegulatorOn().ifPresent(voltageControlOn -> {
            try {
                jsonGenerator.writeBooleanField("voltageRegulatorOn", voltageControlOn.booleanValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        action.getTargetV().ifPresent(targetV -> {
            try {
                jsonGenerator.writeNumberField("targetV", targetV);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        action.getTargetQ().ifPresent(targetQ -> {
            try {
                jsonGenerator.writeNumberField("targetQ", targetQ);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        jsonGenerator.writeEndObject();
    }
}

