/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.results;

import com.powsybl.contingency.Contingency;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.results.AbstractContingencyResult;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PostContingencyResult
extends AbstractContingencyResult {
    private final Contingency contingency;
    private final PostContingencyComputationStatus status;
    private final ConnectivityResult connectivityResult;

    public PostContingencyResult(Contingency contingency, PostContingencyComputationStatus status, LimitViolationsResult limitViolationsResult) {
        this(contingency, status, limitViolationsResult, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new ConnectivityResult(0, 0, 0.0, 0.0, Collections.emptySet()));
    }

    public PostContingencyResult(Contingency contingency, PostContingencyComputationStatus status, LimitViolationsResult limitViolationsResult, List<BranchResult> branchResults, List<BusResult> busResults, List<ThreeWindingsTransformerResult> threeWindingsTransformerResults, ConnectivityResult connectivityResult) {
        this(contingency, status, limitViolationsResult, new NetworkResult(branchResults, busResults, threeWindingsTransformerResults), connectivityResult);
    }

    public PostContingencyResult(Contingency contingency, PostContingencyComputationStatus status, LimitViolationsResult limitViolationsResult, NetworkResult networkResult, ConnectivityResult connectivityResult) {
        super(limitViolationsResult, networkResult);
        this.contingency = Objects.requireNonNull(contingency);
        this.status = Objects.requireNonNull(status);
        this.connectivityResult = Objects.requireNonNull(connectivityResult);
    }

    public PostContingencyResult(Contingency contingency, PostContingencyComputationStatus status, List<LimitViolation> limitViolations, List<BranchResult> branchResults, List<BusResult> busResults, List<ThreeWindingsTransformerResult> threeWindingsTransformerResults, ConnectivityResult connectivityResult) {
        this(contingency, status, new LimitViolationsResult(limitViolations, Collections.emptyList()), branchResults, busResults, threeWindingsTransformerResults, connectivityResult);
    }

    public PostContingencyResult(Contingency contingency, PostContingencyComputationStatus status, List<LimitViolation> limitViolations) {
        this(contingency, status, new LimitViolationsResult(limitViolations, Collections.emptyList()));
    }

    public PostContingencyResult(Contingency contingency, PostContingencyComputationStatus status, List<LimitViolation> limitViolations, List<String> actionsTaken) {
        this(contingency, status, new LimitViolationsResult(limitViolations, actionsTaken));
    }

    public Contingency getContingency() {
        return this.contingency;
    }

    public PostContingencyComputationStatus getStatus() {
        return this.status;
    }

    public ConnectivityResult getConnectivityResult() {
        return this.connectivityResult;
    }
}

