/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.io.table.AsciiTableFormatterFactory;
import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.HorizontalAlignment;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.LimitViolationHelper;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.detectors.DefaultLimitViolationDetector;
import com.powsybl.security.detectors.LoadingLimitType;
import com.powsybl.security.results.PostContingencyResult;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Security {
    private static final String PERMANENT_LIMIT_NAME = "Permanent limit";
    private static final String CONTINGENCY = "Contingency";
    private static final String STATUS = "Status";
    private static final String ACTION = "Action";
    private static final String COUNTRY = "Country";
    private static final String BASE_VOLTAGE = "Base voltage";
    private static final String EQUIPMENT = "Equipment";
    private static final String END = "End";
    private static final String VIOLATION_TYPE = "Violation type";
    private static final String VIOLATION_NAME = "Violation name";
    private static final String VALUE = "Value";
    private static final String LIMIT = "Limit";
    private static final String ABS_VALUE_LIMIT = "abs(value-limit)";
    private static final String LOADING_RATE = "Loading rate %";

    private Security() {
    }

    public static List<LimitViolation> checkLimits(Network network) {
        return Security.checkLimits(network, EnumSet.allOf(LoadingLimitType.class), 1.0);
    }

    public static List<LimitViolation> checkLimits(Network network, double limitReductionValue) {
        return Security.checkLimits(network, EnumSet.allOf(LoadingLimitType.class), limitReductionValue);
    }

    public static List<LimitViolation> checkLimits(Network network, LoadingLimitType currentLimitType, double limitReductionValue) {
        Objects.requireNonNull(currentLimitType);
        return Security.checkLimits(network, EnumSet.of(currentLimitType), limitReductionValue);
    }

    public static List<LimitViolation> checkLimits(Network network, Set<LoadingLimitType> currentLimitTypes, double limitReductionValue) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(currentLimitTypes);
        if (limitReductionValue <= 0.0) {
            throw new IllegalArgumentException("Bad limit reduction " + limitReductionValue);
        }
        ArrayList<LimitViolation> violations = new ArrayList<LimitViolation>();
        new DefaultLimitViolationDetector(limitReductionValue, currentLimitTypes).checkAll(network, violations::add);
        return violations;
    }

    public static List<LimitViolation> checkLimitsDc(Network network, double limitReductionValue, double dcPowerFactor) {
        Objects.requireNonNull(network);
        if (limitReductionValue <= 0.0) {
            throw new IllegalArgumentException("Bad limit reduction " + limitReductionValue);
        }
        if (dcPowerFactor <= 0.0 || dcPowerFactor > 1.0) {
            throw new IllegalArgumentException("Invalid DC power factor " + dcPowerFactor);
        }
        ArrayList<LimitViolation> violations = new ArrayList<LimitViolation>();
        new DefaultLimitViolationDetector(limitReductionValue, EnumSet.allOf(LoadingLimitType.class)).checkAllDc(network, dcPowerFactor, violations::add);
        return violations;
    }

    public static String printLimitsViolations(Network network) {
        return Security.printLimitsViolations(network, LimitViolationFilter.load());
    }

    public static String printLimitsViolations(Network network, boolean writeName) {
        return Security.printLimitsViolations(Security.checkLimits(network), network, new LimitViolationWriteConfig(LimitViolationFilter.load(), TableFormatterConfig.load(), writeName));
    }

    public static String printLimitsViolations(Network network, LimitViolationFilter filter) {
        return Security.printLimitsViolations(Security.checkLimits(network), network, filter);
    }

    public static String printLimitsViolations(List<LimitViolation> violations, Network network) {
        return Security.printLimitsViolations(violations, network, LimitViolationFilter.load());
    }

    public static String printLimitsViolations(List<LimitViolation> violations, Network network, LimitViolationFilter filter) {
        return Security.printLimitsViolations(violations, network, filter, TableFormatterConfig.load());
    }

    public static String printLimitsViolations(List<LimitViolation> violations, Network network, LimitViolationFilter filter, TableFormatterConfig formatterConfig) {
        return Security.printLimitsViolations(violations, network, new LimitViolationWriteConfig(filter, formatterConfig, false));
    }

    public static String printLimitsViolations(List<LimitViolation> violations, Network network, LimitViolationWriteConfig printConfig) {
        Objects.requireNonNull(violations);
        Objects.requireNonNull(network);
        Objects.requireNonNull(printConfig);
        AsciiTableFormatterFactory formatterFactory = new AsciiTableFormatterFactory();
        StringWriter writer = new StringWriter();
        List<LimitViolation> filteredViolations = printConfig.getFilter() != null ? printConfig.getFilter().apply(violations, network) : violations;
        NumberFormat numberFormat = Security.getFormatter(printConfig.getFormatterConfig().getLocale(), 4, 4);
        NumberFormat percentageFormat = Security.getFormatter(printConfig.getFormatterConfig().getLocale(), 2, 2);
        try (TableFormatter formatter = formatterFactory.create((Writer)writer, "", printConfig.getFormatterConfig(), new Column[]{new Column("Equipment (" + filteredViolations.size() + ")"), new Column(END), new Column(COUNTRY), new Column(BASE_VOLTAGE).setHorizontalAlignment(HorizontalAlignment.RIGHT), new Column(VIOLATION_TYPE), new Column(VIOLATION_NAME), new Column(VALUE).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(LIMIT).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(ABS_VALUE_LIMIT).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(LOADING_RATE).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(percentageFormat)});){
            filteredViolations.stream().sorted(Comparator.comparing(LimitViolation::getSubjectId)).forEach(Security.writeLineLimitsViolations(network, formatter, printConfig.isWriteName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString().trim();
    }

    private static Consumer<? super LimitViolation> writeLineLimitsViolations(Network network, TableFormatter formatter, boolean writeName) {
        return violation -> {
            try {
                formatter.writeCell(writeName ? violation.getSubjectName() : violation.getSubjectId()).writeCell(LimitViolationHelper.getVoltageLevelId(violation, network, writeName)).writeCell(LimitViolationHelper.getCountry(violation, network).map(Enum::name).orElse("")).writeCell((int)LimitViolationHelper.getNominalVoltage(violation, network)).writeCell(violation.getLimitType().name()).writeCell(Security.getViolationName(violation)).writeCell(violation.getValue()).writeCell(Security.getViolationLimit(violation)).writeCell(Security.getAbsValueLimit(violation)).writeCell(Security.getViolationRate(violation));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static double getAbsValueLimit(LimitViolation violation) {
        return Math.abs(violation.getValue() - violation.getLimit() * violation.getLimitReduction());
    }

    public static void printPreContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, LimitViolationFilter limitViolationFilter) {
        Security.printPreContingencyViolations(result, network, writer, formatterFactory, TableFormatterConfig.load(), limitViolationFilter);
    }

    public static void printPreContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, TableFormatterConfig formatterConfig, LimitViolationFilter limitViolationFilter) {
        Security.printPreContingencyViolations(result, network, writer, formatterFactory, new LimitViolationWriteConfig(limitViolationFilter, formatterConfig, false));
    }

    public static void printPreContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, LimitViolationWriteConfig printConfig) {
        Objects.requireNonNull(result);
        Objects.requireNonNull(network);
        Objects.requireNonNull(writer);
        Objects.requireNonNull(formatterFactory);
        Objects.requireNonNull(printConfig);
        NumberFormat numberFormat = Security.getFormatter(printConfig.getFormatterConfig().getLocale(), 4, 4);
        NumberFormat percentageFormat = Security.getFormatter(printConfig.getFormatterConfig().getLocale(), 2, 2);
        List<LimitViolation> filteredLimitViolations = printConfig.getFilter() != null ? printConfig.getFilter().apply(result.getPreContingencyLimitViolationsResult().getLimitViolations(), network) : result.getPreContingencyLimitViolationsResult().getLimitViolations();
        try (TableFormatter formatter = formatterFactory.create(writer, "Pre-contingency violations", printConfig.getFormatterConfig(), new Column[]{new Column(ACTION), new Column("Equipment (" + filteredLimitViolations.size() + ")"), new Column(END), new Column(COUNTRY), new Column(BASE_VOLTAGE).setHorizontalAlignment(HorizontalAlignment.RIGHT), new Column(VIOLATION_TYPE), new Column(VIOLATION_NAME), new Column(VALUE).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(LIMIT).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(ABS_VALUE_LIMIT).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(LOADING_RATE).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(percentageFormat)});){
            for (String action : result.getPreContingencyLimitViolationsResult().getActionsTaken()) {
                formatter.writeCell(action).writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell();
            }
            filteredLimitViolations.stream().sorted(Comparator.comparing(LimitViolation::getSubjectId)).forEach(Security.writeLinePreContingencyViolations(network, formatter, printConfig.isWriteName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Consumer<? super LimitViolation> writeLinePreContingencyViolations(Network network, TableFormatter formatter, boolean writeName) {
        return violation -> {
            try {
                formatter.writeEmptyCell().writeCell(writeName ? violation.getSubjectName() : violation.getSubjectId()).writeCell(LimitViolationHelper.getVoltageLevelId(violation, network, writeName)).writeCell(LimitViolationHelper.getCountry(violation, network).map(Enum::name).orElse("")).writeCell((int)LimitViolationHelper.getNominalVoltage(violation, network)).writeCell(violation.getLimitType().name()).writeCell(Security.getViolationName(violation)).writeCell(violation.getValue()).writeCell(Security.getViolationLimit(violation)).writeCell(Security.getAbsValueLimit(violation)).writeCell(Security.getViolationRate(violation));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static String getViolationName(LimitViolation violation) {
        if (violation.getLimitName() != null) {
            return violation.getLimitName();
        }
        if (violation.getAcceptableDuration() != Integer.MAX_VALUE) {
            return String.format("Overload %d'", violation.getAcceptableDuration() / 60);
        }
        if (violation.getLimitType() == LimitViolationType.CURRENT) {
            return PERMANENT_LIMIT_NAME;
        }
        return "";
    }

    private static double getViolationLimit(LimitViolation violation) {
        return violation.getLimit() * violation.getLimitReduction();
    }

    private static double getViolationRate(LimitViolation violation) {
        return Math.abs(violation.getValue()) / violation.getLimit() * 100.0;
    }

    private static NumberFormat getFormatter(Locale locale, int minimumFractionDigits, int maximumFractionDigits) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setMinimumFractionDigits(minimumFractionDigits);
        numberFormat.setMaximumFractionDigits(maximumFractionDigits);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    private static LimitViolationKey toKey(LimitViolation violation) {
        return new LimitViolationKey(violation.getSubjectId(), violation.getLimitType(), violation.getLimit());
    }

    public static void printPostContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, LimitViolationFilter limitViolationFilter) {
        Security.printPostContingencyViolations(result, network, writer, formatterFactory, limitViolationFilter, true);
    }

    public static void printPostContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, LimitViolationFilter limitViolationFilter, boolean filterPreContingencyViolations) {
        Security.printPostContingencyViolations(result, network, writer, formatterFactory, TableFormatterConfig.load(), limitViolationFilter, filterPreContingencyViolations);
    }

    public static void printPostContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, TableFormatterConfig formatterConfig, LimitViolationFilter limitViolationFilter, boolean filterPreContingencyViolations) {
        Security.printPostContingencyViolations(result, network, writer, formatterFactory, new PostContingencyLimitViolationWriteConfig(limitViolationFilter, formatterConfig, false, filterPreContingencyViolations));
    }

    public static void printPostContingencyViolations(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory formatterFactory, PostContingencyLimitViolationWriteConfig writeConfig) {
        Objects.requireNonNull(result);
        Objects.requireNonNull(network);
        Objects.requireNonNull(writer);
        Objects.requireNonNull(formatterFactory);
        Objects.requireNonNull(writeConfig);
        if (!result.getPostContingencyResults().isEmpty()) {
            Set<LimitViolationKey> preContingencyViolations = writeConfig.isFilterPreContingencyViolations() ? result.getPreContingencyLimitViolationsResult().getLimitViolations().stream().map(Security::toKey).collect(Collectors.toSet()) : Collections.emptySet();
            NumberFormat numberFormat = Security.getFormatter(writeConfig.getFormatterConfig().getLocale(), 4, 4);
            NumberFormat percentageFormat = Security.getFormatter(writeConfig.getFormatterConfig().getLocale(), 2, 2);
            int sumFilter = result.getPostContingencyResults().stream().sorted(Comparator.comparing(o2 -> o2.getContingency().getId())).mapToInt(postContingencyResult -> {
                List<LimitViolation> filteredLimitViolations = writeConfig.getFilter() != null ? writeConfig.getFilter().apply(postContingencyResult.getLimitViolationsResult().getLimitViolations(), network) : postContingencyResult.getLimitViolationsResult().getLimitViolations();
                List<LimitViolation> filteredLimitViolations2 = filteredLimitViolations.stream().filter(violation -> preContingencyViolations.isEmpty() || !preContingencyViolations.contains(Security.toKey(violation))).toList();
                return filteredLimitViolations2.size();
            }).sum();
            try (TableFormatter formatter = formatterFactory.create(writer, "Post-contingency limit violations", writeConfig.getFormatterConfig(), new Column[]{new Column(CONTINGENCY), new Column(STATUS), new Column(ACTION), new Column("Equipment (" + sumFilter + ")"), new Column(END), new Column(COUNTRY), new Column(BASE_VOLTAGE).setHorizontalAlignment(HorizontalAlignment.RIGHT), new Column(VIOLATION_TYPE), new Column(VIOLATION_NAME), new Column(VALUE).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(LIMIT).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(ABS_VALUE_LIMIT).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(numberFormat), new Column(LOADING_RATE).setHorizontalAlignment(HorizontalAlignment.RIGHT).setNumberFormat(percentageFormat)});){
                result.getPostContingencyResults().stream().sorted(Comparator.comparing(o2 -> o2.getContingency().getId())).forEach(Security.writePostContingencyResult(writeConfig.getFilter(), network, preContingencyViolations, formatter, writeConfig.isWriteName()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static Consumer<? super PostContingencyResult> writePostContingencyResult(LimitViolationFilter limitViolationFilter, Network network, Set<LimitViolationKey> preContingencyViolations, TableFormatter formatter, boolean writeName) {
        return postContingencyResult -> {
            try {
                List<LimitViolation> filteredLimitViolations = limitViolationFilter != null ? limitViolationFilter.apply(postContingencyResult.getLimitViolationsResult().getLimitViolations(), network) : postContingencyResult.getLimitViolationsResult().getLimitViolations();
                List<LimitViolation> filteredLimitViolations2 = filteredLimitViolations.stream().filter(violation -> preContingencyViolations.isEmpty() || !preContingencyViolations.contains(Security.toKey(violation))).toList();
                if (!filteredLimitViolations2.isEmpty() || postContingencyResult.getStatus() != PostContingencyComputationStatus.CONVERGED) {
                    formatter.writeCell(postContingencyResult.getContingency().getId()).writeCell(postContingencyResult.getStatus().name()).writeEmptyCell().writeCell("Equipment (" + filteredLimitViolations2.size() + ")").writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell();
                    for (String action : postContingencyResult.getLimitViolationsResult().getActionsTaken()) {
                        formatter.writeEmptyCell().writeEmptyCell().writeCell(action).writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell().writeEmptyCell();
                    }
                    filteredLimitViolations2.stream().sorted(Comparator.comparing(LimitViolation::getSubjectId)).forEach(Security.writeLimitViolation(network, formatter, writeName));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static Consumer<? super LimitViolation> writeLimitViolation(Network network, TableFormatter formatter, boolean writeName) {
        return violation -> {
            try {
                formatter.writeEmptyCell().writeEmptyCell().writeEmptyCell().writeCell(writeName ? violation.getSubjectName() : violation.getSubjectId()).writeCell(LimitViolationHelper.getVoltageLevelId(violation, network, writeName)).writeCell(LimitViolationHelper.getCountry(violation, network).map(Enum::name).orElse("")).writeCell((int)LimitViolationHelper.getNominalVoltage(violation, network)).writeCell(violation.getLimitType().name()).writeCell(Security.getViolationName(violation)).writeCell(violation.getValue()).writeCell(Security.getViolationLimit(violation)).writeCell(Security.getAbsValueLimit(violation)).writeCell(Security.getViolationRate(violation));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static void print(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory tableFormatterFactory, TableFormatterConfig tableFormatterConfig) {
        Security.print(result, network, writer, tableFormatterFactory, new PostContingencyLimitViolationWriteConfig(null, tableFormatterConfig, false, true));
    }

    public static void print(SecurityAnalysisResult result, Network network, Writer writer, TableFormatterFactory tableFormatterFactory, PostContingencyLimitViolationWriteConfig writeConfig) {
        Security.printPreContingencyViolations(result, network, writer, tableFormatterFactory, writeConfig);
        Security.printPostContingencyViolations(result, network, writer, tableFormatterFactory, writeConfig);
    }

    public static class LimitViolationWriteConfig {
        private final LimitViolationFilter filter;
        private final TableFormatterConfig formatterConfig;
        private final boolean writeName;

        public LimitViolationWriteConfig(LimitViolationFilter filter, TableFormatterConfig formatterConfig, boolean writeName) {
            this.filter = filter;
            this.formatterConfig = Objects.requireNonNull(formatterConfig);
            this.writeName = writeName;
        }

        public LimitViolationFilter getFilter() {
            return this.filter;
        }

        public TableFormatterConfig getFormatterConfig() {
            return this.formatterConfig;
        }

        public boolean isWriteName() {
            return this.writeName;
        }
    }

    private static class LimitViolationKey {
        private final String id;
        private final LimitViolationType limitType;
        private final double limit;

        public LimitViolationKey(String id, LimitViolationType limitType, double limit) {
            this.id = Objects.requireNonNull(id);
            this.limitType = Objects.requireNonNull(limitType);
            this.limit = limit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.limitType, this.limit});
        }

        public boolean equals(Object obj) {
            if (obj instanceof LimitViolationKey) {
                LimitViolationKey other = (LimitViolationKey)obj;
                return this.id.equals(other.id) && this.limitType == other.limitType && this.limit == other.limit;
            }
            return false;
        }
    }

    public static class PostContingencyLimitViolationWriteConfig
    extends LimitViolationWriteConfig {
        private final boolean filterPreContingencyViolations;

        public PostContingencyLimitViolationWriteConfig(LimitViolationFilter filter, TableFormatterConfig formatterConfig, boolean writeName, boolean filterPreContingencyViolations) {
            super(filter, formatterConfig, writeName);
            this.filterPreContingencyViolations = filterPreContingencyViolations;
        }

        public boolean isFilterPreContingencyViolations() {
            return this.filterPreContingencyViolations;
        }
    }
}

