/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.google.common.collect.ImmutableList;
import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.NetworkMetadata;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SecurityAnalysisResult
extends AbstractExtendable<SecurityAnalysisResult> {
    private NetworkMetadata networkMetadata;
    private final List<PostContingencyResult> postContingencyResults;
    private final PreContingencyResult preContingencyResult;
    private final List<OperatorStrategyResult> operatorStrategyResults;

    public static SecurityAnalysisResult empty() {
        return new SecurityAnalysisResult(new PreContingencyResult(LoadFlowResult.ComponentResult.Status.CONVERGED, LimitViolationsResult.empty(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), Collections.emptyList(), Collections.emptyList());
    }

    public SecurityAnalysisResult(LimitViolationsResult preContingencyResult, LoadFlowResult.ComponentResult.Status preContingencyStatus, List<PostContingencyResult> postContingencyResults) {
        this(new PreContingencyResult(preContingencyStatus, preContingencyResult, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), postContingencyResults, Collections.emptyList());
    }

    public SecurityAnalysisResult(LimitViolationsResult preContingencyResult, LoadFlowResult.ComponentResult.Status preContingencyStatus, List<PostContingencyResult> postContingencyResults, List<BranchResult> preContingencyBranchResults, List<BusResult> preContingencyBusResults, List<ThreeWindingsTransformerResult> preContingencyThreeWindingsTransformerResults, List<OperatorStrategyResult> operatorStrategyResults) {
        this(new PreContingencyResult(preContingencyStatus, preContingencyResult, preContingencyBranchResults, preContingencyBusResults, preContingencyThreeWindingsTransformerResults), postContingencyResults, operatorStrategyResults);
    }

    public SecurityAnalysisResult(PreContingencyResult preContingencyResult, List<PostContingencyResult> postContingencyResults, List<OperatorStrategyResult> operatorStrategyResults) {
        this.preContingencyResult = Objects.requireNonNull(preContingencyResult);
        this.postContingencyResults = ImmutableList.copyOf((Collection)Objects.requireNonNull(postContingencyResults));
        this.operatorStrategyResults = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorStrategyResults));
    }

    public NetworkMetadata getNetworkMetadata() {
        return this.networkMetadata;
    }

    public SecurityAnalysisResult setNetworkMetadata(NetworkMetadata networkMetadata) {
        this.networkMetadata = networkMetadata;
        return this;
    }

    public LimitViolationsResult getPreContingencyLimitViolationsResult() {
        return this.preContingencyResult.getLimitViolationsResult();
    }

    public List<PostContingencyResult> getPostContingencyResults() {
        return this.postContingencyResults;
    }

    public PreContingencyResult getPreContingencyResult() {
        return this.preContingencyResult;
    }

    public List<OperatorStrategyResult> getOperatorStrategyResults() {
        return this.operatorStrategyResults;
    }
}

