/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.Contingency;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.NetworkMetadata;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import com.powsybl.security.interceptors.SecurityAnalysisResultContext;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SecurityAnalysisResultBuilder {
    private final LimitViolationFilter filter;
    private final SecurityAnalysisResultContext context;
    private final List<SecurityAnalysisInterceptor> interceptors;
    private PreContingencyResult preContingencyResult;
    private final List<PostContingencyResult> postContingencyResults = Collections.synchronizedList(new ArrayList());
    private final List<OperatorStrategyResult> operatorStrategyResults = Collections.synchronizedList(new ArrayList());

    public SecurityAnalysisResultBuilder(LimitViolationFilter filter, SecurityAnalysisResultContext context, Collection<SecurityAnalysisInterceptor> interceptors) {
        this.filter = Objects.requireNonNull(filter);
        this.context = Objects.requireNonNull(context);
        this.interceptors = ImmutableList.copyOf(interceptors);
        this.preContingencyResult = new PreContingencyResult();
    }

    public SecurityAnalysisResultBuilder(LimitViolationFilter filter, SecurityAnalysisResultContext context) {
        this(filter, context, Collections.emptyList());
    }

    private void addPostContingencyResult(PostContingencyResult result) {
        this.postContingencyResults.add(Objects.requireNonNull(result));
    }

    public PreContingencyResultBuilder preContingency() {
        return new PreContingencyResultBuilder(this.context);
    }

    public PreContingencyResultBuilder preContingency(SecurityAnalysisResultContext preContingencyResultContext) {
        return new PreContingencyResultBuilder(preContingencyResultContext);
    }

    public PostContingencyResultBuilder contingency(Contingency contingency) {
        return new PostContingencyResultBuilder(contingency, this.context);
    }

    public PostContingencyResultBuilder contingency(Contingency contingency, SecurityAnalysisResultContext postContingencyResultContext) {
        return new PostContingencyResultBuilder(contingency, postContingencyResultContext);
    }

    public OperatorStrategyResultBuilder operatorStrategy(OperatorStrategy strategy) {
        return this.operatorStrategy(strategy, this.context);
    }

    public OperatorStrategyResultBuilder operatorStrategy(OperatorStrategy strategy, SecurityAnalysisResultContext strategyContext) {
        return new OperatorStrategyResultBuilder(strategy, strategyContext);
    }

    public SecurityAnalysisResult build() {
        if (this.preContingencyResult == null) {
            throw new IllegalStateException("Pre-contingency result is not yet defined, cannot build security analysis result.");
        }
        SecurityAnalysisResult res = new SecurityAnalysisResult(this.preContingencyResult, this.postContingencyResults, this.operatorStrategyResults);
        res.setNetworkMetadata(new NetworkMetadata(this.context.getNetwork()));
        this.interceptors.forEach(i -> i.onSecurityAnalysisResult(res, this.context));
        return res;
    }

    public class PreContingencyResultBuilder
    extends AbstractLimitViolationsResultBuilder<PreContingencyResultBuilder> {
        private LoadFlowResult.ComponentResult.Status status;

        PreContingencyResultBuilder(SecurityAnalysisResultContext resultContext) {
            super(resultContext);
            this.status = LoadFlowResult.ComponentResult.Status.CONVERGED;
        }

        public PreContingencyResultBuilder setStatus(LoadFlowResult.ComponentResult.Status status) {
            this.status = status;
            return this;
        }

        public SecurityAnalysisResultBuilder endPreContingency() {
            List<LimitViolation> filteredViolations = SecurityAnalysisResultBuilder.this.filter.apply(this.violations, SecurityAnalysisResultBuilder.this.context.getNetwork());
            SecurityAnalysisResultBuilder.this.preContingencyResult = new PreContingencyResult(this.status, new LimitViolationsResult(filteredViolations), new NetworkResult(this.branchResults, this.busResults, this.threeWindingsTransformerResults));
            SecurityAnalysisResultBuilder.this.interceptors.forEach(i -> i.onPreContingencyResult(SecurityAnalysisResultBuilder.this.preContingencyResult, this.resultContext));
            return SecurityAnalysisResultBuilder.this;
        }
    }

    public class PostContingencyResultBuilder
    extends AbstractLimitViolationsResultBuilder<PostContingencyResultBuilder> {
        private final Contingency contingency;
        private PostContingencyComputationStatus status;
        private ConnectivityResult connectivityResult;

        PostContingencyResultBuilder(Contingency contingency, SecurityAnalysisResultContext resultContext) {
            super(Objects.requireNonNull(resultContext));
            this.contingency = Objects.requireNonNull(contingency);
        }

        @Override
        public PostContingencyResultBuilder addViolation(LimitViolation violation, SecurityAnalysisResultContext limitViolationContext) {
            Objects.requireNonNull(limitViolationContext);
            this.violations.add(Objects.requireNonNull(violation));
            SecurityAnalysisResultBuilder.this.interceptors.forEach(i -> i.onLimitViolation(this.contingency, violation, limitViolationContext));
            return this;
        }

        public PostContingencyResultBuilder setStatus(PostContingencyComputationStatus status) {
            this.status = status;
            return this;
        }

        public PostContingencyResultBuilder setConnectivityResult(ConnectivityResult connectivityResult) {
            this.connectivityResult = connectivityResult;
            return this;
        }

        public SecurityAnalysisResultBuilder endContingency() {
            List<LimitViolation> filteredViolations = SecurityAnalysisResultBuilder.this.filter.apply(this.violations, SecurityAnalysisResultBuilder.this.context.getNetwork());
            PostContingencyResult res = new PostContingencyResult(this.contingency, this.status, filteredViolations, (List<BranchResult>)this.branchResults, (List<BusResult>)this.busResults, (List<ThreeWindingsTransformerResult>)this.threeWindingsTransformerResults, this.connectivityResult);
            SecurityAnalysisResultBuilder.this.interceptors.forEach(i -> i.onPostContingencyResult(res, this.resultContext));
            SecurityAnalysisResultBuilder.this.addPostContingencyResult(res);
            return SecurityAnalysisResultBuilder.this;
        }
    }

    public class OperatorStrategyResultBuilder
    extends AbstractLimitViolationsResultBuilder<OperatorStrategyResultBuilder> {
        private final OperatorStrategy strategy;
        private PostContingencyComputationStatus status;

        OperatorStrategyResultBuilder(OperatorStrategy strategy, SecurityAnalysisResultContext resultContext) {
            super(Objects.requireNonNull(resultContext));
            this.status = PostContingencyComputationStatus.CONVERGED;
            this.strategy = Objects.requireNonNull(strategy);
        }

        @Override
        public OperatorStrategyResultBuilder addViolation(LimitViolation violation, SecurityAnalysisResultContext limitViolationContext) {
            Objects.requireNonNull(limitViolationContext);
            this.violations.add(Objects.requireNonNull(violation));
            return this;
        }

        public OperatorStrategyResultBuilder setStatus(PostContingencyComputationStatus status) {
            this.status = status;
            return this;
        }

        public SecurityAnalysisResultBuilder endOperatorStrategy() {
            List<LimitViolation> filteredViolations = SecurityAnalysisResultBuilder.this.filter.apply(this.violations, SecurityAnalysisResultBuilder.this.context.getNetwork());
            LimitViolationsResult limitViolationsResult = new LimitViolationsResult(filteredViolations);
            NetworkResult networkResult = new NetworkResult(this.branchResults, this.busResults, this.threeWindingsTransformerResults);
            OperatorStrategyResult res = new OperatorStrategyResult(this.strategy, this.status, limitViolationsResult, networkResult);
            SecurityAnalysisResultBuilder.this.operatorStrategyResults.add(res);
            return SecurityAnalysisResultBuilder.this;
        }
    }

    public abstract class AbstractLimitViolationsResultBuilder<B extends AbstractLimitViolationsResultBuilder<B>> {
        protected final List<BranchResult> branchResults = new ArrayList<BranchResult>();
        protected final List<BusResult> busResults = new ArrayList<BusResult>();
        protected final List<ThreeWindingsTransformerResult> threeWindingsTransformerResults = new ArrayList<ThreeWindingsTransformerResult>();
        protected final List<LimitViolation> violations = new ArrayList<LimitViolation>();
        protected final SecurityAnalysisResultContext resultContext;

        private AbstractLimitViolationsResultBuilder(SecurityAnalysisResultContext resultContext) {
            this.resultContext = Objects.requireNonNull(resultContext);
        }

        public B addViolation(LimitViolation violation) {
            this.addViolation(violation, this.resultContext);
            return (B)this;
        }

        public B addViolation(LimitViolation violation, SecurityAnalysisResultContext limitViolationContext) {
            Objects.requireNonNull(limitViolationContext);
            this.violations.add(Objects.requireNonNull(violation));
            SecurityAnalysisResultBuilder.this.interceptors.forEach(i -> i.onLimitViolation(violation, limitViolationContext));
            return (B)this;
        }

        public B addViolations(List<LimitViolation> violations, SecurityAnalysisResultContext limitViolationContext) {
            Objects.requireNonNull(violations).forEach(limitViolation -> this.addViolation((LimitViolation)((Object)limitViolation), limitViolationContext));
            return (B)this;
        }

        public B addViolations(List<LimitViolation> violations) {
            return this.addViolations(violations, this.resultContext);
        }

        public B addBranchResult(BranchResult branchResult) {
            this.branchResults.add(branchResult);
            return (B)this;
        }

        public B addBusResult(BusResult busResult) {
            this.busResults.add(busResult);
            return (B)this;
        }

        public B addThreeWindingsTransformerResult(ThreeWindingsTransformerResult threeWindingsTransformerResult) {
            this.threeWindingsTransformerResults.add(threeWindingsTransformerResult);
            return (B)this;
        }
    }
}

