/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.ExecutionEnvironment;
import com.powsybl.computation.ExecutionHandler;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import com.powsybl.security.distributed.SecurityAnalysisExecutionHandlers;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DistributedSecurityAnalysisExecution
implements SecurityAnalysisExecution {
    private final ExternalSecurityAnalysisConfig config;
    private final int subtaskCount;

    public DistributedSecurityAnalysisExecution(ExternalSecurityAnalysisConfig config, int subtaskCount) {
        this.config = Objects.requireNonNull(config);
        Preconditions.checkArgument((subtaskCount > 0 ? 1 : 0) != 0, (Object)"Sub-tasks count must be positive.");
        this.subtaskCount = DistributedSecurityAnalysisExecution.checkSubtaskCount(subtaskCount);
    }

    @Override
    public CompletableFuture<SecurityAnalysisReport> execute(ComputationManager computationManager, SecurityAnalysisExecutionInput data) {
        ExecutionEnvironment itoolsEnv = new ExecutionEnvironment(Collections.emptyMap(), "security_analysis_task_", this.config.isDebug());
        ExecutionHandler<SecurityAnalysisReport> executionHandler = SecurityAnalysisExecutionHandlers.distributed(data, this.subtaskCount);
        return computationManager.execute(itoolsEnv, executionHandler);
    }

    private static int checkSubtaskCount(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Sub-tasks count must be positive.");
        return count;
    }
}

