/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.computation.Partition;
import com.powsybl.computation.SimpleCommand;
import com.powsybl.computation.SimpleCommandBuilder;
import com.powsybl.security.LimitViolationType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;

public class SecurityAnalysisCommandOptions {
    private String itoolsCommand;
    private String id = "security-analysis";
    private Path caseFile;
    private Path contingenciesFile;
    private Path parametersFile;
    private Path actionsFile;
    private Path strategiesFile;
    private Path limitReductionsFile;
    private Integer taskCount;
    private Function<Integer, Path> outputFile;
    private Function<Integer, Path> logFile;
    private Function<Integer, Partition> task;
    private String outputFileFormat;
    private List<String> resultExtensions = new ArrayList<String>();
    private List<LimitViolationType> violationTypes = new ArrayList<LimitViolationType>();
    private boolean absolutePaths = false;

    public SecurityAnalysisCommandOptions itoolsCommand(String itoolsCommand) {
        this.itoolsCommand = Objects.requireNonNull(itoolsCommand);
        return this;
    }

    public SecurityAnalysisCommandOptions id(String id) {
        this.id = Objects.requireNonNull(id);
        return this;
    }

    public SecurityAnalysisCommandOptions absolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
        return this;
    }

    public SecurityAnalysisCommandOptions caseFile(Path caseFile) {
        this.caseFile = Objects.requireNonNull(caseFile);
        return this;
    }

    public SecurityAnalysisCommandOptions contingenciesFile(Path contingenciesFile) {
        this.contingenciesFile = Objects.requireNonNull(contingenciesFile);
        return this;
    }

    public SecurityAnalysisCommandOptions parametersFile(Path parametersFile) {
        this.parametersFile = Objects.requireNonNull(parametersFile);
        return this;
    }

    public SecurityAnalysisCommandOptions actionsFile(Path actionsFile) {
        this.actionsFile = actionsFile;
        return this;
    }

    public SecurityAnalysisCommandOptions strategiesFile(Path strategiesFile) {
        this.strategiesFile = strategiesFile;
        return this;
    }

    public SecurityAnalysisCommandOptions limitReductionsFile(Path limitReductionsFile) {
        this.limitReductionsFile = limitReductionsFile;
        return this;
    }

    public SecurityAnalysisCommandOptions taskCount(int taskCount) {
        this.taskCount = taskCount;
        return this;
    }

    public SecurityAnalysisCommandOptions outputFile(Function<Integer, Path> outputFile, String format) {
        this.outputFile = Objects.requireNonNull(outputFile);
        this.outputFileFormat = Objects.requireNonNull(format);
        return this;
    }

    public SecurityAnalysisCommandOptions logFile(Path logFile) {
        Objects.requireNonNull(logFile);
        this.logFile = i -> logFile;
        return this;
    }

    public SecurityAnalysisCommandOptions logFile(Function<Integer, Path> logFile) {
        this.logFile = Objects.requireNonNull(logFile);
        return this;
    }

    public SecurityAnalysisCommandOptions outputFile(Path outputFile, String format) {
        Objects.requireNonNull(outputFile);
        this.outputFile = i -> outputFile;
        this.outputFileFormat = Objects.requireNonNull(format);
        return this;
    }

    public SecurityAnalysisCommandOptions taskBasedOnIndex(int taskCount) {
        return this.task((Integer i) -> new Partition(i + 1, taskCount));
    }

    public SecurityAnalysisCommandOptions task(Function<Integer, Partition> task) {
        this.task = Objects.requireNonNull(task);
        return this;
    }

    public SecurityAnalysisCommandOptions task(Partition task) {
        Objects.requireNonNull(task);
        this.task = i -> task;
        return this;
    }

    public SecurityAnalysisCommandOptions resultExtension(String extensionName) {
        this.resultExtensions.add(Objects.requireNonNull(extensionName));
        return this;
    }

    public SecurityAnalysisCommandOptions resultExtensions(Collection<String> extensionNames) {
        this.resultExtensions.addAll(Objects.requireNonNull(extensionNames));
        return this;
    }

    public SecurityAnalysisCommandOptions violationType(LimitViolationType violationType) {
        this.violationTypes.add(Objects.requireNonNull(violationType));
        return this;
    }

    public SecurityAnalysisCommandOptions violationTypes(Collection<LimitViolationType> violationTypes) {
        this.violationTypes.addAll(Objects.requireNonNull(violationTypes));
        return this;
    }

    private String pathToString(Path path) {
        return (this.absolutePaths ? path.toAbsolutePath() : path).toString();
    }

    public SimpleCommand toCommand() {
        Objects.requireNonNull(this.caseFile, "Case file is not defined.");
        Preconditions.checkArgument((this.task == null || this.taskCount == null ? 1 : 0) != 0, (Object)"Options task and task-count may not be defined together.");
        SimpleCommandBuilder commandBuilder = ((SimpleCommandBuilder)new SimpleCommandBuilder().id(this.id)).program(this.itoolsCommand != null ? this.itoolsCommand : SecurityAnalysisCommandOptions.getDefaultItoolsCommand()).arg("security-analysis").option("case-file", this.pathToString(this.caseFile));
        this.setOptionIfPresent(commandBuilder, "parameters-file", this.parametersFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "actions-file", this.actionsFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "strategies-file", this.strategiesFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "contingencies-file", this.contingenciesFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "limit-reductions-file", this.limitReductionsFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "output-file", this.outputFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "output-format", this.outputFileFormat);
        this.setOptionIfPresent(commandBuilder, "log-file", this.logFile, this::pathToString);
        if (!this.resultExtensions.isEmpty()) {
            commandBuilder.option("with-extensions", String.join((CharSequence)",", this.resultExtensions));
        }
        if (!this.violationTypes.isEmpty()) {
            commandBuilder.option("limit-types", this.violationTypes.stream().map(Enum::name).collect(Collectors.joining(",")));
        }
        this.setOptionIfPresent(commandBuilder, "task-count", this.taskCount, (T i) -> Integer.toString(i));
        this.setOptionIfPresent(commandBuilder, "task", this.task, Partition::toString);
        return commandBuilder.build();
    }

    private void setOptionIfPresent(SimpleCommandBuilder commandBuilder, String optionName, String optionValue) {
        if (optionValue != null) {
            commandBuilder.option(optionName, optionValue);
        }
    }

    private <T> void setOptionIfPresent(SimpleCommandBuilder commandBuilder, String optionName, T optionValue, Function<T, String> toString) {
        if (optionValue != null) {
            commandBuilder.option(optionName, toString.apply(optionValue));
        }
    }

    private <T> void setOptionIfPresent(SimpleCommandBuilder commandBuilder, String optionName, Function<Integer, T> optionValue, Function<T, String> toString) {
        if (optionValue != null) {
            commandBuilder.option(optionName, i -> (String)toString.apply(optionValue.apply((Integer)i)));
        }
    }

    private static String getDefaultItoolsCommand() {
        return SystemUtils.IS_OS_WINDOWS ? "itools.bat" : "itools";
    }
}

