/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.powsybl.action.json.ActionJsonModule;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisProvider;
import com.powsybl.security.json.SecurityAnalysisJsonModule;
import com.powsybl.security.json.SecurityAnalysisParametersDeserializer;
import com.powsybl.security.json.SecurityAnalysisParametersSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class JsonSecurityAnalysisParameters {
    private JsonSecurityAnalysisParameters() {
    }

    public static Map<String, ExtensionJsonSerializer> getExtensionSerializers() {
        List providers = new ServiceLoaderCache(SecurityAnalysisProvider.class).getServices();
        return providers.stream().flatMap(securityAnalysisProvider -> securityAnalysisProvider.getSpecificParametersSerializer().stream()).collect(Collectors.toMap(ExtensionProvider::getExtensionName, securityAnalysisProvider -> securityAnalysisProvider));
    }

    public static SecurityAnalysisParameters read(Path jsonFile) {
        return JsonSecurityAnalysisParameters.update(new SecurityAnalysisParameters(), jsonFile);
    }

    public static SecurityAnalysisParameters read(InputStream jsonStream) {
        return JsonSecurityAnalysisParameters.update(new SecurityAnalysisParameters(), jsonStream);
    }

    public static SecurityAnalysisParameters update(SecurityAnalysisParameters parameters, Path jsonFile) {
        SecurityAnalysisParameters securityAnalysisParameters;
        block8: {
            Objects.requireNonNull(jsonFile);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                securityAnalysisParameters = JsonSecurityAnalysisParameters.update(parameters, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return securityAnalysisParameters;
    }

    public static SecurityAnalysisParameters update(SecurityAnalysisParameters parameters, InputStream jsonStream) {
        try {
            ObjectMapper objectMapper = JsonSecurityAnalysisParameters.createObjectMapper();
            return (SecurityAnalysisParameters)((Object)objectMapper.readerForUpdating((Object)parameters).readValue(jsonStream));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(SecurityAnalysisParameters parameters, Path jsonFile) {
        Objects.requireNonNull(jsonFile);
        try (OutputStream outputStream = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            JsonSecurityAnalysisParameters.write(parameters, outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(SecurityAnalysisParameters parameters, OutputStream outputStream) {
        try {
            ObjectMapper objectMapper = JsonSecurityAnalysisParameters.createObjectMapper();
            ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
            writer.writeValue(outputStream, (Object)parameters);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SecurityAnalysisParameters deserialize(JsonParser parser, DeserializationContext context, SecurityAnalysisParameters parameters) throws IOException {
        return new SecurityAnalysisParametersDeserializer().deserialize(parser, context, parameters);
    }

    public static SecurityAnalysisParameters deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return new SecurityAnalysisParametersDeserializer().deserialize(parser, context);
    }

    public static void serialize(SecurityAnalysisParameters parameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        new SecurityAnalysisParametersSerializer().serialize(parameters, jsonGenerator, serializerProvider);
    }

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new SecurityAnalysisJsonModule()).registerModule((Module)new ActionJsonModule());
    }
}

