/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.contingency.json.ContingencyJsonModule;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.NetworkMetadata;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.condition.Condition;
import com.powsybl.security.json.BranchResultDeserializer;
import com.powsybl.security.json.BranchResultSerializer;
import com.powsybl.security.json.BusResultDeserializer;
import com.powsybl.security.json.BusResultSerializer;
import com.powsybl.security.json.ConditionDeserializer;
import com.powsybl.security.json.ConditionSerializer;
import com.powsybl.security.json.ConditionalActionsDeserializer;
import com.powsybl.security.json.ConditionalActionsSerializer;
import com.powsybl.security.json.ConnectivityResultDeserializer;
import com.powsybl.security.json.ConnectivityResultSerializer;
import com.powsybl.security.json.LimitViolationDeserializer;
import com.powsybl.security.json.LimitViolationResultDeserializer;
import com.powsybl.security.json.LimitViolationSerializer;
import com.powsybl.security.json.LimitViolationsResultSerializer;
import com.powsybl.security.json.NetworkMetadataDeserializer;
import com.powsybl.security.json.NetworkMetadataSerializer;
import com.powsybl.security.json.NetworkResultDeserializer;
import com.powsybl.security.json.OperatorStrategyDeserializer;
import com.powsybl.security.json.OperatorStrategyListDeserializer;
import com.powsybl.security.json.OperatorStrategyListSerializer;
import com.powsybl.security.json.OperatorStrategyResultDeserializer;
import com.powsybl.security.json.OperatorStrategyResultSerializer;
import com.powsybl.security.json.OperatorStrategySerializer;
import com.powsybl.security.json.PostContingencyResultDeserializer;
import com.powsybl.security.json.PostContingencyResultSerializer;
import com.powsybl.security.json.PreContingencyResultDeserializer;
import com.powsybl.security.json.PreContingencyResultSerializer;
import com.powsybl.security.json.SecurityAnalysisJsonPlugin;
import com.powsybl.security.json.SecurityAnalysisParametersDeserializer;
import com.powsybl.security.json.SecurityAnalysisParametersSerializer;
import com.powsybl.security.json.SecurityAnalysisResultDeserializer;
import com.powsybl.security.json.SecurityAnalysisResultSerializer;
import com.powsybl.security.json.ThreeWindingsTransformerResultDeserializer;
import com.powsybl.security.json.ThreeWindingsTransformerResultSerializer;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import com.powsybl.security.strategy.ConditionalActions;
import com.powsybl.security.strategy.OperatorStrategy;
import com.powsybl.security.strategy.OperatorStrategyList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SecurityAnalysisJsonModule
extends ContingencyJsonModule {
    private final List<SecurityAnalysisJsonPlugin> plugins;

    public SecurityAnalysisJsonModule() {
        this(SecurityAnalysisJsonModule.getServices());
    }

    private static List<SecurityAnalysisJsonPlugin> getServices() {
        return new ServiceLoaderCache(SecurityAnalysisJsonPlugin.class).getServices();
    }

    public SecurityAnalysisJsonModule(Collection<SecurityAnalysisJsonPlugin> plugins) {
        Objects.requireNonNull(plugins);
        this.plugins = List.copyOf(plugins);
        this.addSerializer(SecurityAnalysisResult.class, (JsonSerializer)new SecurityAnalysisResultSerializer());
        this.addSerializer(NetworkMetadata.class, (JsonSerializer)new NetworkMetadataSerializer());
        this.addSerializer(PostContingencyResult.class, (JsonSerializer)new PostContingencyResultSerializer());
        this.addSerializer(LimitViolationsResult.class, (JsonSerializer)new LimitViolationsResultSerializer());
        this.addSerializer(LimitViolation.class, (JsonSerializer)new LimitViolationSerializer());
        this.addSerializer(PreContingencyResult.class, (JsonSerializer)new PreContingencyResultSerializer());
        this.addSerializer(BusResult.class, (JsonSerializer)new BusResultSerializer());
        this.addSerializer(BranchResult.class, (JsonSerializer)new BranchResultSerializer());
        this.addSerializer(ThreeWindingsTransformerResult.class, (JsonSerializer)new ThreeWindingsTransformerResultSerializer());
        this.addSerializer(SecurityAnalysisParameters.class, (JsonSerializer)new SecurityAnalysisParametersSerializer());
        this.addSerializer(OperatorStrategyResult.class, (JsonSerializer)new OperatorStrategyResultSerializer());
        this.addSerializer(OperatorStrategy.class, (JsonSerializer)new OperatorStrategySerializer());
        this.addSerializer(OperatorStrategyList.class, (JsonSerializer)new OperatorStrategyListSerializer());
        this.addSerializer(ConditionalActions.class, (JsonSerializer)new ConditionalActionsSerializer());
        this.addSerializer(Condition.class, (JsonSerializer)new ConditionSerializer());
        this.addSerializer(ConnectivityResult.class, (JsonSerializer)new ConnectivityResultSerializer());
        this.addDeserializer(SecurityAnalysisResult.class, (JsonDeserializer)new SecurityAnalysisResultDeserializer());
        this.addDeserializer(NetworkMetadata.class, (JsonDeserializer)new NetworkMetadataDeserializer());
        this.addDeserializer(PostContingencyResult.class, (JsonDeserializer)new PostContingencyResultDeserializer());
        this.addDeserializer(LimitViolationsResult.class, (JsonDeserializer)new LimitViolationResultDeserializer());
        this.addDeserializer(LimitViolation.class, (JsonDeserializer)new LimitViolationDeserializer());
        this.addDeserializer(PreContingencyResult.class, (JsonDeserializer)new PreContingencyResultDeserializer());
        this.addDeserializer(BusResult.class, (JsonDeserializer)new BusResultDeserializer());
        this.addDeserializer(BranchResult.class, (JsonDeserializer)new BranchResultDeserializer());
        this.addDeserializer(ThreeWindingsTransformerResult.class, (JsonDeserializer)new ThreeWindingsTransformerResultDeserializer());
        this.addDeserializer(SecurityAnalysisParameters.class, (JsonDeserializer)new SecurityAnalysisParametersDeserializer());
        this.addDeserializer(OperatorStrategyResult.class, (JsonDeserializer)new OperatorStrategyResultDeserializer());
        this.addDeserializer(OperatorStrategy.class, (JsonDeserializer)new OperatorStrategyDeserializer());
        this.addDeserializer(OperatorStrategyList.class, (JsonDeserializer)new OperatorStrategyListDeserializer());
        this.addDeserializer(ConditionalActions.class, (JsonDeserializer)new ConditionalActionsDeserializer());
        this.addDeserializer(Condition.class, (JsonDeserializer)new ConditionDeserializer());
        this.addDeserializer(NetworkResult.class, (JsonDeserializer)new NetworkResultDeserializer());
        this.addDeserializer(ConnectivityResult.class, (JsonDeserializer)new ConnectivityResultDeserializer());
    }

    public Iterable<? extends Module> getDependencies() {
        return () -> this.plugins.stream().flatMap(plugin -> plugin.getJsonModules().stream()).iterator();
    }
}

