/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.json.JsonLoadFlowParameters;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.json.JsonSecurityAnalysisParameters;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SecurityAnalysisParametersDeserializer
extends StdDeserializer<SecurityAnalysisParameters> {
    private static final String CONTEXT_NAME = "SecurityAnalysisParameters";

    SecurityAnalysisParametersDeserializer() {
        super(SecurityAnalysisParameters.class);
    }

    public SecurityAnalysisParameters deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(parser, deserializationContext, new SecurityAnalysisParameters());
    }

    public SecurityAnalysisParameters deserialize(JsonParser parser, DeserializationContext deserializationContext, SecurityAnalysisParameters parameters) throws IOException {
        List extensions = Collections.emptyList();
        String version = null;
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    continue block12;
                }
                case "increased-violations-parameters": {
                    JsonUtil.assertGreaterThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: specificCompatibility", version, (String)"1.0");
                    parser.nextToken();
                    parameters.setIncreasedViolationsParameters((SecurityAnalysisParameters.IncreasedViolationsParameters)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, SecurityAnalysisParameters.IncreasedViolationsParameters.class));
                    continue block12;
                }
                case "load-flow-parameters": {
                    parser.nextToken();
                    JsonLoadFlowParameters.deserialize((JsonParser)parser, (DeserializationContext)deserializationContext, (LoadFlowParameters)parameters.getLoadFlowParameters());
                    continue block12;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.updateExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, JsonSecurityAnalysisParameters.getExtensionSerializers()::get, (Extendable)parameters);
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        extensions.forEach(extension -> parameters.addExtension(extension.getClass(), (Extension)extension));
        return parameters;
    }
}

