/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.preprocessor;

import com.google.common.io.ByteSource;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.ContingenciesProviderFactory;
import com.powsybl.security.SecurityAnalysisConfig;
import com.powsybl.security.preprocessor.ContingenciesProviderPreprocessorFactory;
import com.powsybl.security.preprocessor.SecurityAnalysisPreprocessor;
import com.powsybl.security.preprocessor.SecurityAnalysisPreprocessorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SecurityAnalysisPreprocessors {
    private SecurityAnalysisPreprocessors() {
    }

    public static SecurityAnalysisPreprocessorFactory factoryForName(String name) {
        Objects.requireNonNull(name);
        List factories = new ServiceLoaderCache(SecurityAnalysisPreprocessorFactory.class).getServices();
        return factories.stream().filter(f -> f.getName().equals(name)).findFirst().orElseThrow(() -> new PowsyblException("Could not find any security analysis preprocessor for name " + name));
    }

    public static Optional<SecurityAnalysisPreprocessorFactory> defaultConfiguredFactory() {
        return SecurityAnalysisPreprocessors.configuredFactory(PlatformConfig.defaultConfig());
    }

    public static Optional<SecurityAnalysisPreprocessorFactory> configuredFactory(PlatformConfig platformConfig) {
        return SecurityAnalysisPreprocessors.configuredFactory(SecurityAnalysisConfig.load(platformConfig));
    }

    public static Optional<SecurityAnalysisPreprocessorFactory> configuredFactory(SecurityAnalysisConfig config) {
        return config.getPreprocessorName().map(SecurityAnalysisPreprocessors::factoryForName);
    }

    public static SecurityAnalysisPreprocessorFactory wrap(ContingenciesProviderFactory factory) {
        return new ContingenciesProviderPreprocessorFactory(factory);
    }

    public static SecurityAnalysisPreprocessor contingenciesPreprocessor(ContingenciesProviderFactory factory, ByteSource source) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(source);
        return configuration -> configuration.setContingencies(SecurityAnalysisPreprocessors.newContingenciesProvider(factory, source));
    }

    private static ContingenciesProvider newContingenciesProvider(ContingenciesProviderFactory factory, ByteSource byteSource) {
        ContingenciesProvider contingenciesProvider;
        block8: {
            InputStream is = byteSource.openBufferedStream();
            try {
                contingenciesProvider = factory.create(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return contingenciesProvider;
    }
}

