/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.strategy;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableList;
import com.powsybl.action.json.ActionJsonModule;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.json.SecurityAnalysisJsonModule;
import com.powsybl.security.strategy.OperatorStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class OperatorStrategyList {
    private final List<OperatorStrategy> operatorStrategies;
    public static final String VERSION = "1.1";

    public OperatorStrategyList(List<OperatorStrategy> operatorStrategies) {
        this.operatorStrategies = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorStrategies));
    }

    public List<OperatorStrategy> getOperatorStrategies() {
        return this.operatorStrategies;
    }

    public static OperatorStrategyList read(Path jsonFile) {
        OperatorStrategyList operatorStrategyList;
        block8: {
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                operatorStrategyList = OperatorStrategyList.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return operatorStrategyList;
    }

    public static OperatorStrategyList read(InputStream is) {
        Objects.requireNonNull(is);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper().registerModule((Module)new SecurityAnalysisJsonModule()).registerModule((Module)new ActionJsonModule());
        try {
            return (OperatorStrategyList)objectMapper.readValue(is, OperatorStrategyList.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(Path jsonFile) {
        Objects.requireNonNull(jsonFile);
        try (OutputStream outputStream = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            this.write(outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(OutputStream outputStream) {
        try {
            ObjectMapper objectMapper = OperatorStrategyList.createObjectMapper();
            ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
            writer.writeValue(outputStream, (Object)this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new SecurityAnalysisJsonModule()).registerModule((Module)new ActionJsonModule());
    }
}

