/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.ViolationLocation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class LimitViolationDeserializer
extends StdDeserializer<LimitViolation> {
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"security-analysis"));
    public static final String VIOLATION_LOCATION_SUPPORT = "violationLocationSupport";
    private static final String CONTEXT_NAME = "limit-violation";

    public LimitViolationDeserializer() {
        super(LimitViolation.class);
    }

    public LimitViolation deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        Boolean voltageLocationSupport = (Boolean)deserializationContext.getAttribute((Object)VIOLATION_LOCATION_SUPPORT);
        String subjectId = null;
        String subjectName = null;
        LimitViolationType limitType = null;
        String limitName = null;
        int acceptableDuration = Integer.MAX_VALUE;
        double limit = Double.NaN;
        double limitReduction = Double.NaN;
        double value = Double.NaN;
        ThreeSides side = null;
        ViolationLocation violationLocation = null;
        List extensions = Collections.emptyList();
        block26: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "subjectId": {
                    subjectId = parser.nextTextValue();
                    continue block26;
                }
                case "subjectName": {
                    subjectName = parser.nextTextValue();
                    continue block26;
                }
                case "limitType": {
                    parser.nextToken();
                    limitType = (LimitViolationType)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolationType.class));
                    continue block26;
                }
                case "limitName": {
                    limitName = parser.nextTextValue();
                    continue block26;
                }
                case "acceptableDuration": {
                    parser.nextToken();
                    acceptableDuration = (Integer)parser.readValueAs(Integer.class);
                    continue block26;
                }
                case "limit": {
                    parser.nextToken();
                    limit = (Double)parser.readValueAs(Double.class);
                    continue block26;
                }
                case "limitReduction": {
                    parser.nextToken();
                    limitReduction = ((Float)parser.readValueAs(Float.class)).floatValue();
                    continue block26;
                }
                case "value": {
                    parser.nextToken();
                    value = (Double)parser.readValueAs(Double.class);
                    continue block26;
                }
                case "side": {
                    parser.nextToken();
                    side = (ThreeSides)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ThreeSides.class);
                    continue block26;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, SUPPLIER.get());
                    continue block26;
                }
                case "violationLocation": {
                    if (Boolean.FALSE.equals(voltageLocationSupport)) {
                        throw new PowsyblException(String.format("%s. %s is not valid for this version ", CONTEXT_NAME, "violationLocation"));
                    }
                    parser.nextToken();
                    violationLocation = (ViolationLocation)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ViolationLocation.class);
                    continue block26;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        LimitViolation violation = new LimitViolation(subjectId, subjectName, limitType, limitName, acceptableDuration, limit, limitReduction, value, side, violationLocation);
        SUPPLIER.get().addExtensions((Extendable)violation, (Collection)extensions);
        return violation;
    }
}

