/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.action.Action;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractSecurityAnalysisRunParameters<T extends AbstractSecurityAnalysisRunParameters<T>> {
    protected static final Supplier<LimitViolationFilter> DEFAULT_FILTER_SUPPLIER = LimitViolationFilter::load;
    protected static final Supplier<ComputationManager> DEFAULT_COMPUTATION_MANAGER_SUPPLIER = LocalComputationManager::getDefault;
    private LimitViolationFilter filter;
    private ComputationManager computationManager;
    private List<SecurityAnalysisInterceptor> interceptors = new ArrayList<SecurityAnalysisInterceptor>();
    private List<OperatorStrategy> operatorStrategies = new ArrayList<OperatorStrategy>();
    private List<Action> actions = new ArrayList<Action>();
    private List<StateMonitor> monitors = new ArrayList<StateMonitor>();
    private ReportNode reportNode = ReportNode.NO_OP;

    public LimitViolationFilter getFilter() {
        if (this.filter == null) {
            this.setFilter(DEFAULT_FILTER_SUPPLIER.get());
        }
        return this.filter;
    }

    public ComputationManager getComputationManager() {
        if (this.computationManager == null) {
            this.setComputationManager(DEFAULT_COMPUTATION_MANAGER_SUPPLIER.get());
        }
        return this.computationManager;
    }

    public List<SecurityAnalysisInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<OperatorStrategy> getOperatorStrategies() {
        return this.operatorStrategies;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public List<StateMonitor> getMonitors() {
        return this.monitors;
    }

    public ReportNode getReportNode() {
        return this.reportNode;
    }

    public T setFilter(LimitViolationFilter filter) {
        Objects.requireNonNull(filter, "LimitViolationFilter should not be null");
        this.filter = filter;
        return this.self();
    }

    public T setComputationManager(ComputationManager computationManager) {
        Objects.requireNonNull(computationManager, "ComputationManager should not be null");
        this.computationManager = computationManager;
        return this.self();
    }

    public T setOperatorStrategies(List<OperatorStrategy> operatorStrategies) {
        Objects.requireNonNull(operatorStrategies, "OperatorStrategy list should not be null");
        this.operatorStrategies = operatorStrategies;
        return this.self();
    }

    public T setInterceptors(List<SecurityAnalysisInterceptor> interceptors) {
        Objects.requireNonNull(interceptors, "Interceptor list should not be null");
        this.interceptors = interceptors;
        return this.self();
    }

    public T setMonitors(List<StateMonitor> monitors) {
        Objects.requireNonNull(monitors, "StateMonitor list should not be null");
        this.monitors = monitors;
        return this.self();
    }

    public T setActions(List<Action> actions) {
        Objects.requireNonNull(actions, "Action list should not be null");
        this.actions = actions;
        return this.self();
    }

    public T setReportNode(ReportNode reportNode) {
        Objects.requireNonNull(reportNode, "ReportNode should not be null");
        this.reportNode = reportNode;
        return this.self();
    }

    public T addOperatorStrategy(OperatorStrategy operatorStrategy) {
        Objects.requireNonNull(operatorStrategy, "OperatorStrategy should not be null");
        this.operatorStrategies.add(operatorStrategy);
        return this.self();
    }

    public T addInterceptor(SecurityAnalysisInterceptor interceptor) {
        Objects.requireNonNull(interceptor, "Interceptor should not be null");
        this.interceptors.add(interceptor);
        return this.self();
    }

    public T addMonitor(StateMonitor monitor) {
        Objects.requireNonNull(monitor, "StateMonitor should not be null");
        this.monitors.add(monitor);
        return this.self();
    }

    public T addAction(Action action) {
        Objects.requireNonNull(action, "Action should not be null");
        this.actions.add(action);
        return this.self();
    }

    protected abstract T self();
}

