/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.SecurityAnalysisProvider;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisRunParameters;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class SecurityAnalysis {
    private SecurityAnalysis() {
        throw new IllegalStateException("Utility class should not been instantiated");
    }

    public static Runner find(String name) {
        return new Runner((SecurityAnalysisProvider)PlatformConfigNamedProvider.Finder.find((String)name, (String)"security-analysis", SecurityAnalysisProvider.class, (PlatformConfig)PlatformConfig.defaultConfig()));
    }

    public static Runner find() {
        return SecurityAnalysis.find(null);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisRunParameters runParameters) {
        return SecurityAnalysis.find().runAsync(network, workingStateId, contingenciesProvider, runParameters);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies, SecurityAnalysisRunParameters runParameters) {
        return SecurityAnalysis.find().runAsync(network, contingencies, runParameters);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies) {
        return SecurityAnalysis.find().runAsync(network, contingencies);
    }

    public static SecurityAnalysisReport run(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisRunParameters runParameters) {
        return SecurityAnalysis.find().run(network, workingStateId, contingenciesProvider, runParameters);
    }

    public static SecurityAnalysisReport run(Network network, List<Contingency> contingencies, SecurityAnalysisRunParameters runParameters) {
        return SecurityAnalysis.find().run(network, contingencies, runParameters);
    }

    public static SecurityAnalysisReport run(Network network, List<Contingency> contingencies) {
        return SecurityAnalysis.find().run(network, contingencies);
    }

    public static final class Runner
    implements Versionable {
        private final SecurityAnalysisProvider provider;

        public Runner(SecurityAnalysisProvider provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisRunParameters runParameters) {
            Objects.requireNonNull(network, "Network should not be null");
            Objects.requireNonNull(workingStateId, "WorkingVariantId should not be null");
            Objects.requireNonNull(contingenciesProvider, "Contingencies provider should not be null");
            Objects.requireNonNull(runParameters, "SecurityAnalysisRunParameters should not be null");
            return this.provider.run(network, workingStateId, contingenciesProvider, runParameters);
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies, SecurityAnalysisRunParameters runParameters) {
            return this.runAsync(network, network.getVariantManager().getWorkingVariantId(), n -> contingencies, runParameters);
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies) {
            return this.runAsync(network, contingencies, SecurityAnalysisRunParameters.getDefault());
        }

        public SecurityAnalysisReport run(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisRunParameters runParameters) {
            return this.runAsync(network, workingStateId, contingenciesProvider, runParameters).join();
        }

        public SecurityAnalysisReport run(Network network, List<Contingency> contingencies, SecurityAnalysisRunParameters runParameters) {
            return this.run(network, network.getVariantManager().getWorkingVariantId(), n -> contingencies, runParameters);
        }

        public SecurityAnalysisReport run(Network network, List<Contingency> contingencies) {
            return this.run(network, contingencies, SecurityAnalysisRunParameters.getDefault());
        }

        public String getName() {
            return this.provider.getName();
        }

        public String getVersion() {
            return this.provider.getVersion();
        }
    }
}

