/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.config.PlatformConfig;
import java.util.Objects;
import java.util.Optional;

public class SecurityAnalysisConfig {
    private static final String DEFAULT_PREPROCESSOR_NAME = null;
    private final String preprocessorName;

    public SecurityAnalysisConfig() {
        this(DEFAULT_PREPROCESSOR_NAME);
    }

    public SecurityAnalysisConfig(String preprocessorName) {
        this.preprocessorName = preprocessorName;
    }

    public Optional<String> getPreprocessorName() {
        return Optional.ofNullable(this.preprocessorName);
    }

    public static SecurityAnalysisConfig load() {
        return SecurityAnalysisConfig.load(PlatformConfig.defaultConfig());
    }

    public static SecurityAnalysisConfig load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        return platformConfig.getOptionalModuleConfig("security-analysis").flatMap(module -> module.getOptionalStringProperty("preprocessor")).map(SecurityAnalysisConfig::new).orElseGet(SecurityAnalysisConfig::new);
    }
}

