/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.security.SecurityAnalysisProvider;
import com.powsybl.security.json.JsonSecurityAnalysisParameters;
import java.nio.file.Path;
import java.util.Objects;

public class SecurityAnalysisParameters
extends AbstractExtendable<SecurityAnalysisParameters> {
    public static final String VERSION = "1.2";
    private LoadFlowParameters loadFlowParameters = new LoadFlowParameters();
    private IncreasedViolationsParameters increasedViolationsParameters = new IncreasedViolationsParameters();
    static final boolean DEFAULT_INTERMEDIATE_RESULTS_IN_OPERATOR_STRATEGY = false;
    private boolean intermediateResultsInOperatorStrategy = false;

    public static SecurityAnalysisParameters load() {
        return SecurityAnalysisParameters.load(PlatformConfig.defaultConfig());
    }

    public static SecurityAnalysisParameters load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        SecurityAnalysisParameters parameters = new SecurityAnalysisParameters();
        parameters.setLoadFlowParameters(LoadFlowParameters.load((PlatformConfig)platformConfig));
        platformConfig.getOptionalModuleConfig("security-analysis-default-parameters").ifPresent(config -> {
            parameters.setIntermediateResultsInOperatorStrategy(config.getBooleanProperty("intermediate-results-in-operator-strategy", false));
            parameters.getIncreasedViolationsParameters().load((ModuleConfig)config);
        });
        parameters.readExtensions(platformConfig);
        return parameters;
    }

    private void readExtensions(PlatformConfig platformConfig) {
        for (SecurityAnalysisProvider provider : new ServiceLoaderCache(SecurityAnalysisProvider.class).getServices()) {
            provider.loadSpecificParameters(platformConfig).ifPresent(securityAnalysisParametersExtension -> this.addExtension(securityAnalysisParametersExtension.getClass(), (Extension)securityAnalysisParametersExtension));
        }
    }

    public IncreasedViolationsParameters getIncreasedViolationsParameters() {
        return this.increasedViolationsParameters;
    }

    public SecurityAnalysisParameters setIncreasedViolationsParameters(IncreasedViolationsParameters increasedViolationsParameters) {
        this.increasedViolationsParameters = Objects.requireNonNull(increasedViolationsParameters);
        return this;
    }

    public void write(Path parametersPath) {
        JsonSecurityAnalysisParameters.write(this, parametersPath);
    }

    public SecurityAnalysisParameters setIntermediateResultsInOperatorStrategy(boolean intermediateResultsInOperatorStrategy) {
        this.intermediateResultsInOperatorStrategy = intermediateResultsInOperatorStrategy;
        return this;
    }

    public boolean getIntermediateResultsInOperatorStrategy() {
        return this.intermediateResultsInOperatorStrategy;
    }

    public LoadFlowParameters getLoadFlowParameters() {
        return this.loadFlowParameters;
    }

    public SecurityAnalysisParameters setLoadFlowParameters(LoadFlowParameters loadFlowParameters) {
        this.loadFlowParameters = Objects.requireNonNull(loadFlowParameters);
        return this;
    }

    public void update(Path parametersPath) {
        JsonSecurityAnalysisParameters.update(this, parametersPath);
    }

    public static class IncreasedViolationsParameters {
        static final double DEFAULT_FLOW_PROPORTIONAL_THRESHOLD = 0.1;
        static final double DEFAULT_LOW_VOLTAGE_PROPORTIONAL_THRESHOLD = 0.0;
        static final double DEFAULT_HIGH_VOLTAGE_PROPORTIONAL_THRESHOLD = 0.0;
        static final double DEFAULT_LOW_VOLTAGE_ABSOLUTE_THRESHOLD = 0.0;
        static final double DEFAULT_HIGH_VOLTAGE_ABSOLUTE_THRESHOLD = 0.0;
        @JsonProperty(value="flow-proportional-threshold")
        private double flowProportionalThreshold = 0.1;
        @JsonProperty(value="low-voltage-proportional-threshold")
        private double lowVoltageProportionalThreshold = 0.0;
        @JsonProperty(value="low-voltage-absolute-threshold")
        private double lowVoltageAbsoluteThreshold = 0.0;
        @JsonProperty(value="high-voltage-proportional-threshold")
        private double highVoltageProportionalThreshold = 0.0;
        @JsonProperty(value="high-voltage-absolute-threshold")
        private double highVoltageAbsoluteThreshold = 0.0;

        public IncreasedViolationsParameters(double lowVoltageAbsoluteThreshold, double lowVoltageProportionalThreshold, double highVoltageAbsoluteThreshold, double highVoltageProportionalThreshold, double flowProportionalThreshold) {
            this.lowVoltageAbsoluteThreshold = lowVoltageAbsoluteThreshold;
            this.lowVoltageProportionalThreshold = lowVoltageProportionalThreshold;
            this.highVoltageAbsoluteThreshold = highVoltageAbsoluteThreshold;
            this.highVoltageProportionalThreshold = highVoltageProportionalThreshold;
            this.flowProportionalThreshold = flowProportionalThreshold;
        }

        public IncreasedViolationsParameters() {
        }

        public double getLowVoltageAbsoluteThreshold() {
            return this.lowVoltageAbsoluteThreshold;
        }

        public double getLowVoltageProportionalThreshold() {
            return this.lowVoltageProportionalThreshold;
        }

        public double getHighVoltageAbsoluteThreshold() {
            return this.highVoltageAbsoluteThreshold;
        }

        public double getHighVoltageProportionalThreshold() {
            return this.highVoltageProportionalThreshold;
        }

        public double getFlowProportionalThreshold() {
            return this.flowProportionalThreshold;
        }

        public IncreasedViolationsParameters setLowVoltageAbsoluteThreshold(double lowVoltageAbsoluteThreshold) {
            this.lowVoltageAbsoluteThreshold = lowVoltageAbsoluteThreshold;
            return this;
        }

        public IncreasedViolationsParameters setLowVoltageProportionalThreshold(double lowVoltageProportionalThreshold) {
            this.lowVoltageProportionalThreshold = lowVoltageProportionalThreshold;
            return this;
        }

        public IncreasedViolationsParameters setHighVoltageAbsoluteThreshold(double highVoltageAbsoluteThreshold) {
            this.highVoltageAbsoluteThreshold = highVoltageAbsoluteThreshold;
            return this;
        }

        public IncreasedViolationsParameters setHighVoltageProportionalThreshold(double highVoltageProportionalThreshold) {
            this.highVoltageProportionalThreshold = highVoltageProportionalThreshold;
            return this;
        }

        public IncreasedViolationsParameters setFlowProportionalThreshold(double flowProportionalThreshold) {
            this.flowProportionalThreshold = flowProportionalThreshold;
            return this;
        }

        public void load(ModuleConfig config) {
            this.setFlowProportionalThreshold(config.getDoubleProperty("increased-flow-violations-proportional-threshold", 0.1)).setLowVoltageProportionalThreshold(config.getDoubleProperty("increased-low-voltage-violations-proportional-threshold", 0.0)).setHighVoltageProportionalThreshold(config.getDoubleProperty("increased-high-voltage-violations-proportional-threshold", 0.0)).setLowVoltageAbsoluteThreshold(config.getDoubleProperty("increased-low-voltage-violations-absolute-threshold", 0.0)).setHighVoltageAbsoluteThreshold(config.getDoubleProperty("increased-high-voltage-violations-absolute-threshold", 0.0));
        }
    }
}

