/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.computation.ComputationManager;
import com.powsybl.security.AbstractSecurityAnalysisRunParameters;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.limitreduction.LimitReduction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class SecurityAnalysisRunParameters
extends AbstractSecurityAnalysisRunParameters<SecurityAnalysisRunParameters> {
    private static final Supplier<SecurityAnalysisParameters> DEFAULT_SA_PARAMETERS_SUPPLIER = SecurityAnalysisParameters::load;
    private SecurityAnalysisParameters securityAnalysisParameters;
    private List<LimitReduction> limitReductions = new ArrayList<LimitReduction>();

    public static SecurityAnalysisRunParameters getDefault() {
        return (SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)new SecurityAnalysisRunParameters().setFilter((LimitViolationFilter)DEFAULT_FILTER_SUPPLIER.get())).setSecurityAnalysisParameters(DEFAULT_SA_PARAMETERS_SUPPLIER.get()).setComputationManager((ComputationManager)DEFAULT_COMPUTATION_MANAGER_SUPPLIER.get());
    }

    public SecurityAnalysisParameters getSecurityAnalysisParameters() {
        if (this.securityAnalysisParameters == null) {
            this.setSecurityAnalysisParameters(DEFAULT_SA_PARAMETERS_SUPPLIER.get());
        }
        return this.securityAnalysisParameters;
    }

    public List<LimitReduction> getLimitReductions() {
        return this.limitReductions;
    }

    public SecurityAnalysisRunParameters setSecurityAnalysisParameters(SecurityAnalysisParameters securityAnalysisParameters) {
        Objects.requireNonNull(securityAnalysisParameters, "Security analysis parameters should not be null");
        this.securityAnalysisParameters = securityAnalysisParameters;
        return this.self();
    }

    public SecurityAnalysisRunParameters setLimitReductions(List<LimitReduction> limitReductions) {
        Objects.requireNonNull(limitReductions, "LimitReductions list should not be null");
        this.limitReductions = limitReductions;
        return this.self();
    }

    public SecurityAnalysisRunParameters addLimitReduction(LimitReduction limitReduction) {
        Objects.requireNonNull(limitReduction, "LimitReduction should not be null");
        this.limitReductions.add(limitReduction);
        return this.self();
    }

    @Override
    protected SecurityAnalysisRunParameters self() {
        return this;
    }
}

