/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.comparator;

import com.google.common.base.Equivalence;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.comparator.LimitViolationComparator;
import com.powsybl.security.comparator.LimitViolationsResultEquivalence;
import com.powsybl.security.comparator.PostContingencyResultComparator;
import com.powsybl.security.comparator.SecurityAnalysisResultComparisonWriter;
import com.powsybl.security.results.PostContingencyResult;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Objects;

public class SecurityAnalysisResultEquivalence
extends Equivalence<SecurityAnalysisResult> {
    private final double threshold;
    private SecurityAnalysisResultComparisonWriter comparisonWriter;

    public SecurityAnalysisResultEquivalence(double threshold, Writer writer) {
        this.threshold = threshold;
        this.comparisonWriter = new SecurityAnalysisResultComparisonWriter(writer);
    }

    protected boolean doEquivalent(SecurityAnalysisResult result1, SecurityAnalysisResult result2) {
        PostContingencyResult postContingencyResult1;
        LimitViolationsResultEquivalence violationsResultEquivalence = new LimitViolationsResultEquivalence(this.threshold, this.comparisonWriter);
        PostContingencyResultComparator postContingencyResultComparator = new PostContingencyResultComparator();
        boolean equivalent = result1.getPreContingencyResult().getStatus() == result2.getPreContingencyResult().getStatus();
        equivalent &= violationsResultEquivalence.equivalent(result1.getPreContingencyLimitViolationsResult(), result2.getPreContingencyLimitViolationsResult());
        ArrayList<PostContingencyResult> postContingencyResults1 = new ArrayList<PostContingencyResult>(result1.getPostContingencyResults());
        ArrayList<PostContingencyResult> postContingencyResults2 = new ArrayList<PostContingencyResult>(result2.getPostContingencyResults());
        postContingencyResults1.sort(postContingencyResultComparator);
        postContingencyResults2.sort(postContingencyResultComparator);
        int index1 = 0;
        int index2 = 0;
        while (index1 < postContingencyResults1.size() && index2 < postContingencyResults2.size()) {
            PostContingencyResult postContingencyResult2;
            postContingencyResult1 = (PostContingencyResult)postContingencyResults1.get(index1);
            int postContingencyResultComparison = postContingencyResultComparator.compare(postContingencyResult1, postContingencyResult2 = (PostContingencyResult)postContingencyResults2.get(index2));
            if (postContingencyResultComparison == 0) {
                this.comparisonWriter.setContingency(postContingencyResult1.getContingency().getId());
                equivalent &= violationsResultEquivalence.equivalent(postContingencyResult1.getLimitViolationsResult(), postContingencyResult2.getLimitViolationsResult());
                ++index1;
                ++index2;
                continue;
            }
            if (postContingencyResultComparison < 0) {
                equivalent &= this.onlySmallViolations(postContingencyResult1, false);
                ++index1;
                continue;
            }
            equivalent &= this.onlySmallViolations(postContingencyResult2, true);
            ++index2;
        }
        while (index1 < postContingencyResults1.size()) {
            postContingencyResult1 = (PostContingencyResult)postContingencyResults1.get(index1);
            equivalent &= this.onlySmallViolations(postContingencyResult1, false);
            ++index1;
        }
        while (index2 < postContingencyResults2.size()) {
            PostContingencyResult postContingencyResult2 = (PostContingencyResult)postContingencyResults2.get(index2);
            equivalent &= this.onlySmallViolations(postContingencyResult2, true);
            ++index2;
        }
        return equivalent;
    }

    private boolean onlySmallViolations(PostContingencyResult postContingencyResult, boolean missingResult1) {
        this.comparisonWriter.setContingency(postContingencyResult.getContingency().getId());
        boolean equivalent = postContingencyResult.getLimitViolationsResult().getLimitViolations().stream().sorted(new LimitViolationComparator()).map(violation -> this.isSmallViolation((LimitViolation)((Object)violation), missingResult1)).reduce(Boolean::logicalAnd).orElse(false);
        this.comparisonWriter = missingResult1 ? this.comparisonWriter.write(null, postContingencyResult.getStatus() == PostContingencyComputationStatus.CONVERGED, equivalent) : this.comparisonWriter.write(postContingencyResult.getStatus() == PostContingencyComputationStatus.CONVERGED, null, equivalent);
        this.comparisonWriter = missingResult1 ? this.comparisonWriter.write(null, postContingencyResult.getLimitViolationsResult().getActionsTaken(), equivalent) : this.comparisonWriter.write(postContingencyResult.getLimitViolationsResult().getActionsTaken(), null, equivalent);
        return equivalent;
    }

    private boolean isSmallViolation(LimitViolation violation, boolean missingResult1) {
        boolean smallViolation = Math.abs(violation.getValue() - violation.getLimit() * violation.getLimitReduction()) <= this.threshold;
        this.comparisonWriter = missingResult1 ? this.comparisonWriter.write(null, violation, smallViolation) : this.comparisonWriter.write(violation, null, smallViolation);
        return smallViolation;
    }

    protected int doHash(SecurityAnalysisResult result) {
        return Objects.hashCode((Object)result);
    }
}

