/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.converter;

import com.google.auto.service.AutoService;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.converter.SecurityAnalysisResultExporter;
import com.powsybl.security.json.SecurityAnalysisResultSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

@AutoService(value={SecurityAnalysisResultExporter.class})
public class JsonSecurityAnalysisResultExporter
implements SecurityAnalysisResultExporter {
    @Override
    public String getFormat() {
        return "JSON";
    }

    @Override
    public String getComment() {
        return "Export a security analysis result in JSON format";
    }

    @Override
    public void export(SecurityAnalysisResult result, Writer writer) {
        try {
            SecurityAnalysisResultSerializer.write(result, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

