/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.computation.Partition;
import com.powsybl.computation.SimpleCommand;
import com.powsybl.computation.SimpleCommandBuilder;
import com.powsybl.security.LimitViolationType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;

public abstract class AbstractSecurityAnalysisCommandOptions<T extends AbstractSecurityAnalysisCommandOptions<T>> {
    private String itoolsCommand;
    private String id;
    private Path caseFile;
    private Path contingenciesFile;
    private Path parametersFile;
    private Path actionsFile;
    private Path strategiesFile;
    private Path limitReductionsFile;
    private Integer taskCount;
    private IntFunction<Path> outputFile;
    private IntFunction<Path> logFile;
    private IntFunction<Partition> task;
    private String outputFileFormat;
    private List<String> resultExtensions;
    private List<LimitViolationType> violationTypes;
    private boolean absolutePaths;

    protected AbstractSecurityAnalysisCommandOptions(String id) {
        this.id = id;
        this.resultExtensions = new ArrayList<String>();
        this.violationTypes = new ArrayList<LimitViolationType>();
        this.absolutePaths = false;
    }

    public T itoolsCommand(String itoolsCommand) {
        this.itoolsCommand = Objects.requireNonNull(itoolsCommand);
        return this.self();
    }

    public T id(String id) {
        this.id = Objects.requireNonNull(id);
        return this.self();
    }

    public T absolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
        return this.self();
    }

    public T caseFile(Path caseFile) {
        this.caseFile = Objects.requireNonNull(caseFile);
        return this.self();
    }

    public T contingenciesFile(Path contingenciesFile) {
        this.contingenciesFile = Objects.requireNonNull(contingenciesFile);
        return this.self();
    }

    public T parametersFile(Path parametersFile) {
        this.parametersFile = Objects.requireNonNull(parametersFile);
        return this.self();
    }

    public T actionsFile(Path actionsFile) {
        this.actionsFile = actionsFile;
        return this.self();
    }

    public T strategiesFile(Path strategiesFile) {
        this.strategiesFile = strategiesFile;
        return this.self();
    }

    public T limitReductionsFile(Path limitReductionsFile) {
        this.limitReductionsFile = limitReductionsFile;
        return this.self();
    }

    public T taskCount(int taskCount) {
        this.taskCount = taskCount;
        return this.self();
    }

    public T outputFile(IntFunction<Path> outputFile, String format) {
        this.outputFile = Objects.requireNonNull(outputFile);
        this.outputFileFormat = Objects.requireNonNull(format);
        return this.self();
    }

    public T logFile(Path logFile) {
        Objects.requireNonNull(logFile);
        this.logFile = i -> logFile;
        return this.self();
    }

    public T logFile(IntFunction<Path> logFile) {
        this.logFile = Objects.requireNonNull(logFile);
        return this.self();
    }

    public T outputFile(Path outputFile, String format) {
        Objects.requireNonNull(outputFile);
        this.outputFile = i -> outputFile;
        this.outputFileFormat = Objects.requireNonNull(format);
        return this.self();
    }

    public T taskBasedOnIndex(int taskCount) {
        return this.task((int i) -> new Partition(i + 1, taskCount));
    }

    public T task(IntFunction<Partition> task) {
        this.task = Objects.requireNonNull(task);
        return this.self();
    }

    public T task(Partition task) {
        Objects.requireNonNull(task);
        this.task = i -> task;
        return this.self();
    }

    public T resultExtension(String extensionName) {
        this.resultExtensions.add(Objects.requireNonNull(extensionName));
        return this.self();
    }

    public T resultExtensions(Collection<String> extensionNames) {
        this.resultExtensions.addAll(Objects.requireNonNull(extensionNames));
        return this.self();
    }

    public T violationType(LimitViolationType violationType) {
        this.violationTypes.add(Objects.requireNonNull(violationType));
        return this.self();
    }

    public T violationTypes(Collection<LimitViolationType> violationTypes) {
        this.violationTypes.addAll(Objects.requireNonNull(violationTypes));
        return this.self();
    }

    protected String pathToString(Path path) {
        return (this.absolutePaths ? path.toAbsolutePath() : path).toString();
    }

    public SimpleCommand toCommand() {
        return this.toCommandBuilder().build();
    }

    protected SimpleCommandBuilder toCommandBuilder() {
        Objects.requireNonNull(this.caseFile, "Case file is not defined.");
        Preconditions.checkArgument((this.task == null || this.taskCount == null ? 1 : 0) != 0, (Object)"Options task and task-count may not be defined together.");
        SimpleCommandBuilder commandBuilder = ((SimpleCommandBuilder)new SimpleCommandBuilder().id(this.id)).program(this.itoolsCommand != null ? this.itoolsCommand : AbstractSecurityAnalysisCommandOptions.getDefaultItoolsCommand()).arg(this.getCommandName()).option("case-file", this.pathToString(this.caseFile));
        this.setOptionIfPresent(commandBuilder, "parameters-file", this.parametersFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "actions-file", this.actionsFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "strategies-file", this.strategiesFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "contingencies-file", this.contingenciesFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "limit-reductions-file", this.limitReductionsFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "output-file", this.outputFile, this::pathToString);
        this.setOptionIfPresent(commandBuilder, "output-format", this.outputFileFormat);
        this.setOptionIfPresent(commandBuilder, "log-file", this.logFile, this::pathToString);
        if (!this.resultExtensions.isEmpty()) {
            commandBuilder.option("with-extensions", String.join((CharSequence)",", this.resultExtensions));
        }
        if (!this.violationTypes.isEmpty()) {
            commandBuilder.option("limit-types", this.violationTypes.stream().map(Enum::name).collect(Collectors.joining(",")));
        }
        this.setOptionIfPresent(commandBuilder, "task-count", this.taskCount, (R i) -> Integer.toString(i));
        this.setOptionIfPresent(commandBuilder, "task", this.task, Partition::toString);
        return commandBuilder;
    }

    protected void setOptionIfPresent(SimpleCommandBuilder commandBuilder, String optionName, String optionValue) {
        if (optionValue != null) {
            commandBuilder.option(optionName, optionValue);
        }
    }

    protected <R> void setOptionIfPresent(SimpleCommandBuilder commandBuilder, String optionName, R optionValue, Function<R, String> toString) {
        if (optionValue != null) {
            commandBuilder.option(optionName, toString.apply(optionValue));
        }
    }

    protected <R> void setOptionIfPresent(SimpleCommandBuilder commandBuilder, String optionName, IntFunction<R> optionValue, Function<R, String> toString) {
        if (optionValue != null) {
            commandBuilder.option(optionName, i -> (String)toString.apply(optionValue.apply((int)i)));
        }
    }

    protected abstract String getCommandName();

    protected abstract T self();

    private static String getDefaultItoolsCommand() {
        return SystemUtils.IS_OS_WINDOWS ? "itools.bat" : "itools";
    }
}

