/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.powsybl.computation.Partition;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractSecurityAnalysisExecutionBuilder<T extends AbstractSecurityAnalysisExecutionBuilder<T>> {
    protected final Supplier<ExternalSecurityAnalysisConfig> externalConfig;
    protected final String providerName;
    protected boolean forward = false;
    protected Integer taskCount = null;
    protected Partition subPart = null;

    protected AbstractSecurityAnalysisExecutionBuilder(Supplier<ExternalSecurityAnalysisConfig> externalConfig, String providerName) {
        this.externalConfig = Objects.requireNonNull(externalConfig);
        this.providerName = providerName;
    }

    public T forward(boolean forward) {
        this.forward = forward;
        return this.self();
    }

    public T distributed(Integer taskCount) {
        this.taskCount = taskCount;
        return this.self();
    }

    public T subTask(Partition part) {
        this.subPart = part;
        return this.self();
    }

    protected abstract T self();
}

