/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.powsybl.computation.Partition;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.ContingenciesProviders;
import com.powsybl.security.SecurityAnalysisInput;
import com.powsybl.security.distributed.DistributedSecurityAnalysisExecution;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import com.powsybl.security.distributed.ForwardedSecurityAnalysisExecution;
import com.powsybl.security.execution.AbstractSecurityAnalysisExecutionBuilder;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionImpl;
import com.powsybl.security.execution.SecurityAnalysisInputBuildStrategy;
import java.util.Objects;
import java.util.function.Supplier;

public class SecurityAnalysisExecutionBuilder
extends AbstractSecurityAnalysisExecutionBuilder<SecurityAnalysisExecutionBuilder> {
    private final SecurityAnalysisInputBuildStrategy inputBuildStrategy;

    public SecurityAnalysisExecutionBuilder(Supplier<ExternalSecurityAnalysisConfig> externalConfig, String providerName, SecurityAnalysisInputBuildStrategy inputBuildStrategy) {
        super(externalConfig, providerName);
        this.inputBuildStrategy = Objects.requireNonNull(inputBuildStrategy);
    }

    public SecurityAnalysisExecution build() {
        if (this.forward) {
            return new ForwardedSecurityAnalysisExecution((ExternalSecurityAnalysisConfig)this.externalConfig.get(), this.taskCount);
        }
        if (this.taskCount != null) {
            return new DistributedSecurityAnalysisExecution((ExternalSecurityAnalysisConfig)this.externalConfig.get(), this.taskCount);
        }
        return new SecurityAnalysisExecutionImpl(this.providerName, this.inputBuildStrategy());
    }

    private SecurityAnalysisInputBuildStrategy inputBuildStrategy() {
        return this.subPart != null ? this.subPartBuildStrategy() : this.inputBuildStrategy;
    }

    protected SecurityAnalysisInputBuildStrategy subPartBuildStrategy() {
        return executionInput -> {
            SecurityAnalysisInput input = this.inputBuildStrategy.buildFrom(executionInput);
            input.setContingencies(ContingenciesProviders.newSubProvider((ContingenciesProvider)input.getContingenciesProvider(), (Partition)this.subPart));
            return input;
        };
    }

    @Override
    protected SecurityAnalysisExecutionBuilder self() {
        return this;
    }
}

