/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.powsybl.computation.ComputationManager;
import com.powsybl.security.SecurityAnalysis;
import com.powsybl.security.SecurityAnalysisInput;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisRunParameters;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import com.powsybl.security.execution.SecurityAnalysisInputBuildStrategy;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class SecurityAnalysisExecutionImpl
implements SecurityAnalysisExecution {
    private final String staticProviderName;
    private final SecurityAnalysisInputBuildStrategy inputBuildStrategy;

    public SecurityAnalysisExecutionImpl() {
        this(null, SecurityAnalysisExecutionImpl::buildDefault);
    }

    public SecurityAnalysisExecutionImpl(String staticProviderName) {
        this(staticProviderName, SecurityAnalysisExecutionImpl::buildDefault);
    }

    public SecurityAnalysisExecutionImpl(String staticProviderName, SecurityAnalysisInputBuildStrategy inputBuildStrategy) {
        this.staticProviderName = staticProviderName;
        this.inputBuildStrategy = Objects.requireNonNull(inputBuildStrategy);
    }

    private static SecurityAnalysisInput buildDefault(SecurityAnalysisExecutionInput executionInput) {
        return new SecurityAnalysisInput(executionInput.getNetworkVariant());
    }

    @Override
    public CompletableFuture<SecurityAnalysisReport> execute(ComputationManager computationManager, SecurityAnalysisExecutionInput data) {
        SecurityAnalysis.Runner runner = SecurityAnalysis.find(this.staticProviderName);
        SecurityAnalysisInput input = this.inputBuildStrategy.buildFrom(data);
        SecurityAnalysisRunParameters runParameters = ((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)new SecurityAnalysisRunParameters().setSecurityAnalysisParameters(input.getParameters()).setComputationManager(computationManager)).setFilter(input.getFilter())).setInterceptors(new ArrayList<SecurityAnalysisInterceptor>(input.getInterceptors()))).setOperatorStrategies(data.getOperatorStrategies())).setActions(data.getActions())).setMonitors(data.getMonitors())).setLimitReductions(data.getLimitReductions());
        return runner.runAsync(input.getNetworkVariant().getNetwork(), input.getNetworkVariant().getVariantId(), input.getContingenciesProvider(), runParameters);
    }
}

