/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.security.LimitViolation;

public class ActivePowerExtension
extends AbstractExtension<LimitViolation> {
    private LimitViolation limitViolation;
    private final double preContingencyValue;
    private final double postContingencyValue;

    public ActivePowerExtension(double preContingencyValue) {
        this.preContingencyValue = ActivePowerExtension.checkValue(preContingencyValue);
        this.postContingencyValue = Double.NaN;
    }

    public ActivePowerExtension(double preContingencyValue, double postContingencyValue) {
        this.preContingencyValue = ActivePowerExtension.checkValue(preContingencyValue);
        this.postContingencyValue = ActivePowerExtension.checkValue(postContingencyValue);
    }

    public String getName() {
        return "ActivePower";
    }

    public LimitViolation getExtendable() {
        return this.limitViolation;
    }

    public void setExtendable(LimitViolation limitViolation) {
        this.limitViolation = limitViolation;
    }

    public double getPreContingencyValue() {
        return this.preContingencyValue;
    }

    public double getPostContingencyValue() {
        return this.postContingencyValue;
    }

    private static double checkValue(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Value is undefined");
        }
        return value;
    }
}

