/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.interceptors;

import com.google.common.base.Suppliers;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptorExtension;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class SecurityAnalysisInterceptors {
    private static final Supplier<Map<String, SecurityAnalysisInterceptorExtension>> EXTENSIONS = Suppliers.memoize(SecurityAnalysisInterceptors::loadExtensions);

    private static Map<String, SecurityAnalysisInterceptorExtension> loadExtensions() {
        return new ServiceLoaderCache(SecurityAnalysisInterceptorExtension.class).getServices().stream().collect(Collectors.toMap(SecurityAnalysisInterceptorExtension::getName, e -> e));
    }

    public static Set<String> getExtensionNames() {
        return EXTENSIONS.get().keySet();
    }

    public static SecurityAnalysisInterceptor createInterceptor(String name) {
        Objects.requireNonNull(name);
        SecurityAnalysisInterceptorExtension extension = EXTENSIONS.get().get(name);
        if (extension == null) {
            throw new IllegalArgumentException("The extension '" + name + "' doesn't exist");
        }
        return extension.createInterceptor();
    }

    private SecurityAnalysisInterceptors() {
    }
}

