/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.NetworkMetadata;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class NetworkMetadataDeserializer
extends StdDeserializer<NetworkMetadata> {
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"security-analysis"));

    public NetworkMetadataDeserializer() {
        super(NetworkMetadata.class);
    }

    public NetworkMetadata deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String id = null;
        String sourceFormat = null;
        ZonedDateTime caseDate = null;
        int forecastDistance = 0;
        List extensions = Collections.emptyList();
        block14: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "id": {
                    id = parser.nextTextValue();
                    continue block14;
                }
                case "sourceFormat": {
                    sourceFormat = parser.nextTextValue();
                    continue block14;
                }
                case "caseDate": {
                    caseDate = ZonedDateTime.parse(parser.nextTextValue());
                    continue block14;
                }
                case "forecastDistance": {
                    forecastDistance = parser.nextIntValue(0);
                    continue block14;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, SUPPLIER.get());
                    continue block14;
                }
            }
            throw new PowsyblException("Unexpected field: " + parser.currentName());
        }
        NetworkMetadata metadata = new NetworkMetadata(id, sourceFormat, caseDate, forecastDistance);
        SUPPLIER.get().addExtensions((Extendable)metadata, extensions);
        return metadata;
    }
}

