/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.limitreduction;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.iidm.criteria.NetworkElementCriterion;
import com.powsybl.iidm.criteria.duration.LimitDurationCriterion;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.security.limitreduction.LimitReduction;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class LimitReductionDeserializer
extends StdDeserializer<LimitReduction> {
    public LimitReductionDeserializer() {
        super(LimitReduction.class);
    }

    public LimitReduction deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parseObject((JsonParser)parser, fieldName -> {
            switch (fieldName) {
                case "value": {
                    parser.nextToken();
                    context.value = ((Float)parser.readValueAs(Float.class)).floatValue();
                    return true;
                }
                case "limitType": {
                    context.limitType = LimitType.valueOf((String)parser.nextTextValue());
                    return true;
                }
                case "monitoringOnly": {
                    context.monitoringOnly = parser.nextBooleanValue();
                    return true;
                }
                case "contingencyContext": {
                    parser.nextToken();
                    context.contingencyContext = (ContingencyContext)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ContingencyContext.class);
                    return true;
                }
                case "equipmentCriteria": {
                    parser.nextToken();
                    context.networkElementCriteria = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, NetworkElementCriterion.class);
                    return true;
                }
                case "durationCriteria": {
                    parser.nextToken();
                    context.durationCriteria = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, LimitDurationCriterion.class);
                    return true;
                }
            }
            return false;
        });
        LimitReduction.Builder builder = LimitReduction.builder(LimitReductionDeserializer.checkAttribute(context.limitType, "limitType"), LimitReductionDeserializer.checkAttribute(Float.valueOf(context.value), "value").floatValue()).withMonitoringOnly(LimitReductionDeserializer.checkAttribute(context.monitoringOnly, "monitoringOnly")).withContingencyContext(LimitReductionDeserializer.checkAttribute(context.contingencyContext, "contingencyContext"));
        if (context.networkElementCriteria != null) {
            builder.withNetworkElementCriteria(context.networkElementCriteria);
        }
        if (context.durationCriteria != null) {
            builder.withLimitDurationCriteria(context.durationCriteria);
        }
        return builder.build();
    }

    private static <T> T checkAttribute(T object, String attributeName) {
        return Objects.requireNonNull(object, String.format("'%s' attribute is missing (or null)", attributeName));
    }

    private static class ParsingContext {
        float value;
        LimitType limitType;
        Boolean monitoringOnly;
        ContingencyContext contingencyContext;
        List<NetworkElementCriterion> networkElementCriteria;
        List<LimitDurationCriterion> durationCriteria;

        private ParsingContext() {
        }
    }
}

