/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.limitreduction;

import com.google.common.collect.ImmutableList;
import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.iidm.criteria.NetworkElementCriterion;
import com.powsybl.iidm.criteria.duration.LimitDurationCriterion;
import com.powsybl.iidm.network.LimitType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LimitReduction {
    private final LimitType limitType;
    private final double value;
    private final boolean monitoringOnly;
    private final ContingencyContext contingencyContext;
    private final List<NetworkElementCriterion> networkElementCriteria;
    private final List<LimitDurationCriterion> durationCriteria;

    private boolean isSupportedLimitType(LimitType limitType) {
        return limitType == LimitType.CURRENT || limitType == LimitType.ACTIVE_POWER || limitType == LimitType.APPARENT_POWER;
    }

    public LimitReduction(LimitType limitType, double value) {
        this(limitType, value, false);
    }

    public LimitReduction(LimitType limitType, double value, boolean monitoringOnly) {
        this(limitType, value, monitoringOnly, ContingencyContext.all(), Collections.emptyList(), Collections.emptyList());
    }

    public static Builder builder(LimitType limitType, double value) {
        return new Builder(limitType, value);
    }

    private LimitReduction(LimitType limitType, double value, boolean monitoringOnly, ContingencyContext contingencyContext, List<NetworkElementCriterion> networkElementCriteria, List<LimitDurationCriterion> limitDurationCriteria) {
        if (!this.isSupportedLimitType(limitType)) {
            throw new PowsyblException(limitType + " is not a supported limit type for limit reduction");
        }
        this.limitType = limitType;
        if (value > 1.0 || value < 0.0) {
            throw new PowsyblException("Limit reduction value should be in [0;1]");
        }
        this.value = value;
        this.monitoringOnly = monitoringOnly;
        this.contingencyContext = contingencyContext;
        this.networkElementCriteria = networkElementCriteria;
        this.durationCriteria = limitDurationCriteria;
    }

    public LimitType getLimitType() {
        return this.limitType;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isMonitoringOnly() {
        return this.monitoringOnly;
    }

    public ContingencyContext getContingencyContext() {
        return this.contingencyContext;
    }

    public List<NetworkElementCriterion> getNetworkElementCriteria() {
        return this.networkElementCriteria;
    }

    public List<LimitDurationCriterion> getDurationCriteria() {
        return this.durationCriteria;
    }

    public static class Builder {
        private final LimitType limitType;
        private final double value;
        private boolean monitoringOnly = false;
        private ContingencyContext contingencyContext = ContingencyContext.all();
        private List<NetworkElementCriterion> networkElementCriteria = Collections.emptyList();
        private List<LimitDurationCriterion> limitDurationCriteria = Collections.emptyList();

        protected Builder(LimitType limitType, double value) {
            this.limitType = limitType;
            this.value = value;
        }

        public Builder withMonitoringOnly(boolean monitoringOnly) {
            this.monitoringOnly = monitoringOnly;
            return this;
        }

        public Builder withContingencyContext(ContingencyContext contingencyContext) {
            this.contingencyContext = Objects.requireNonNull(contingencyContext);
            return this;
        }

        public Builder withNetworkElementCriteria(NetworkElementCriterion ... networkElementCriteria) {
            return this.withNetworkElementCriteria(List.of(networkElementCriteria));
        }

        public Builder withNetworkElementCriteria(List<NetworkElementCriterion> networkElementCriteria) {
            this.networkElementCriteria = ImmutableList.copyOf((Collection)Objects.requireNonNull(networkElementCriteria));
            return this;
        }

        public Builder withLimitDurationCriteria(LimitDurationCriterion ... limitDurationCriteria) {
            return this.withLimitDurationCriteria(List.of(limitDurationCriteria));
        }

        public Builder withLimitDurationCriteria(List<LimitDurationCriterion> limitDurationCriteria) {
            this.limitDurationCriteria = ImmutableList.copyOf((Collection)Objects.requireNonNull(limitDurationCriteria));
            return this;
        }

        public LimitReduction build() {
            return new LimitReduction(this.limitType, this.value, this.monitoringOnly, this.contingencyContext, this.networkElementCriteria, this.limitDurationCriteria);
        }
    }
}

