/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.limitreduction.computation;

import com.powsybl.iidm.network.limitmodification.result.IdenticalLimitsContainer;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public abstract class AbstractLimitsReducer<L> {
    private final L originalLimits;
    private double permanentLimitReduction = 1.0;
    protected final Map<Integer, Double> temporaryLimitReductionByAcceptableDuration = new HashMap<Integer, Double>();

    protected AbstractLimitsReducer(L originalLimits) {
        this.originalLimits = originalLimits;
    }

    protected abstract LimitsContainer<L> reduce();

    public abstract IntStream getTemporaryLimitsAcceptableDurationStream();

    public LimitsContainer<L> getLimits() {
        if (this.getPermanentLimitReduction() == 1.0 && (this.temporaryLimitReductionByAcceptableDuration.isEmpty() || this.temporaryLimitReductionByAcceptableDuration.values().stream().allMatch(v -> v == 1.0))) {
            return new IdenticalLimitsContainer(this.getOriginalLimits());
        }
        return this.reduce();
    }

    public L getOriginalLimits() {
        return this.originalLimits;
    }

    public void setPermanentLimitReduction(double permanentLimitReduction) {
        this.permanentLimitReduction = permanentLimitReduction;
    }

    public double getPermanentLimitReduction() {
        return this.permanentLimitReduction;
    }

    public void setTemporaryLimitReduction(int acceptableDuration, double limitReduction) {
        this.temporaryLimitReductionByAcceptableDuration.put(acceptableDuration, limitReduction);
    }

    public double getTemporaryLimitReduction(int acceptableDuration) {
        return this.temporaryLimitReductionByAcceptableDuration.getOrDefault(acceptableDuration, 1.0);
    }

    protected static double applyReduction(double value, double reduction) {
        return value == Double.MAX_VALUE ? Double.MAX_VALUE : value * reduction;
    }
}

