/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.limitreduction.computation;

import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import com.powsybl.security.limitreduction.computation.AbstractLimitsReducer;
import com.powsybl.security.limitreduction.result.AbstractReducedLoadingLimits;
import com.powsybl.security.limitreduction.result.DefaultReducedLimitsContainer;
import com.powsybl.security.limitreduction.result.ReducedActivePowerLimits;
import com.powsybl.security.limitreduction.result.ReducedApparentPowerLimits;
import com.powsybl.security.limitreduction.result.ReducedCurrentLimits;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;

public class DefaultLimitsReducer
extends AbstractLimitsReducer<LoadingLimits> {
    public DefaultLimitsReducer(LoadingLimits originalLimits) {
        super(originalLimits);
    }

    @Override
    protected LimitsContainer<LoadingLimits> reduce() {
        LoadingLimits originalLimits = (LoadingLimits)this.getOriginalLimits();
        double reducedPermanentLimit = DefaultLimitsReducer.applyReduction(originalLimits.getPermanentLimit(), this.getPermanentLimitReduction());
        AbstractReducedLoadingLimits reducedLoadingLimits = this.init(originalLimits.getLimitType(), reducedPermanentLimit, originalLimits.getPermanentLimit(), this.getPermanentLimitReduction());
        List<LoadingLimits.TemporaryLimit> temporaryLimits = originalLimits.getTemporaryLimits().stream().sorted(Comparator.comparing(LoadingLimits.TemporaryLimit::getAcceptableDuration)).toList();
        double previousRetainedReducedValue = Double.NaN;
        for (LoadingLimits.TemporaryLimit tl : temporaryLimits) {
            double reduction = this.getTemporaryLimitReduction(tl.getAcceptableDuration());
            double tlReducedValue = DefaultLimitsReducer.applyReduction(tl.getValue(), reduction);
            if (!Double.isNaN(previousRetainedReducedValue) && !(tlReducedValue < previousRetainedReducedValue)) continue;
            previousRetainedReducedValue = tlReducedValue;
            reducedLoadingLimits.addTemporaryLimit(tl.getName(), tlReducedValue, tl.getAcceptableDuration(), tl.isFictitious(), tl.getValue(), reduction);
        }
        return new DefaultReducedLimitsContainer(reducedLoadingLimits, originalLimits);
    }

    @Override
    public IntStream getTemporaryLimitsAcceptableDurationStream() {
        return ((LoadingLimits)this.getOriginalLimits()).getTemporaryLimits().stream().mapToInt(LoadingLimits.TemporaryLimit::getAcceptableDuration);
    }

    private AbstractReducedLoadingLimits init(LimitType type, double permanentLimit, double originalPermanentLimit, double permanentLimitReduction) {
        return switch (type) {
            case LimitType.ACTIVE_POWER -> new ReducedActivePowerLimits(permanentLimit, originalPermanentLimit, permanentLimitReduction);
            case LimitType.APPARENT_POWER -> new ReducedApparentPowerLimits(permanentLimit, originalPermanentLimit, permanentLimitReduction);
            case LimitType.CURRENT -> new ReducedCurrentLimits(permanentLimit, originalPermanentLimit, permanentLimitReduction);
            default -> throw new IllegalArgumentException(String.format("Unsupported limits type for reductions (%s)", type));
        };
    }
}

