/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.limitreduction.result;

import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.util.LoadingLimitsUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeMap;

public abstract class AbstractReducedLoadingLimits
implements LoadingLimits {
    private final double permanentLimit;
    private final double originalPermanentLimit;
    private final double permanentLimitReduction;
    private final TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits = new TreeMap(LoadingLimitsUtil.ACCEPTABLE_DURATION_COMPARATOR);

    protected AbstractReducedLoadingLimits(double permanentLimit, double originalPermanentLimit, double permanentLimitReduction) {
        this.permanentLimit = permanentLimit;
        this.originalPermanentLimit = originalPermanentLimit;
        this.permanentLimitReduction = permanentLimitReduction;
    }

    public void addTemporaryLimit(String name, double value, int acceptableDuration, boolean fictitious, double originalValue, double limitReduction) {
        this.temporaryLimits.put(acceptableDuration, new ReducedTemporaryLimit(name, value, acceptableDuration, fictitious, originalValue, limitReduction));
    }

    public double getPermanentLimit() {
        return this.permanentLimit;
    }

    public double getOriginalPermanentLimit() {
        return this.originalPermanentLimit;
    }

    public double getPermanentLimitReduction() {
        return this.permanentLimitReduction;
    }

    public Collection<LoadingLimits.TemporaryLimit> getTemporaryLimits() {
        return this.temporaryLimits.values();
    }

    public LoadingLimits.TemporaryLimit getTemporaryLimit(int acceptableDuration) {
        return this.temporaryLimits.get(acceptableDuration);
    }

    public double getTemporaryLimitValue(int acceptableDuration) {
        return Optional.ofNullable(this.getTemporaryLimit(acceptableDuration)).map(LoadingLimits.TemporaryLimit::getValue).orElse(Double.NaN);
    }

    public LoadingLimits setPermanentLimit(double permanentLimit) {
        throw new UnsupportedOperationException("Unsupported operation for reduced loading limits.");
    }

    public LoadingLimits setTemporaryLimitValue(int acceptableDuration, double temporaryLimitValue) {
        throw new UnsupportedOperationException("Unsupported operation for reduced loading limits.");
    }

    public void remove() {
        throw new UnsupportedOperationException("Reduced loading limits are not linked to a network element and thus cannot be removed.");
    }

    public record ReducedTemporaryLimit(String name, double value, int acceptableDuration, boolean fictitious, double originalValue, double limitReduction) implements LoadingLimits.TemporaryLimit
    {
        public String getName() {
            return this.name();
        }

        public double getValue() {
            return this.value();
        }

        public int getAcceptableDuration() {
            return this.acceptableDuration();
        }

        public boolean isFictitious() {
            return this.fictitious();
        }

        public double getOriginalValue() {
            return this.originalValue();
        }

        public double getLimitReduction() {
            return this.limitReduction();
        }
    }
}

