/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.results;

import com.powsybl.commons.extensions.AbstractExtendable;
import java.util.Objects;

public class BranchResult
extends AbstractExtendable<BranchResult> {
    private final String branchId;
    private final double p1;
    private final double q1;
    private final double i1;
    private final double p2;
    private final double q2;
    private final double i2;
    private final double flowTransfer;

    public BranchResult(String branchId, double p1, double q1, double i1, double p2, double q2, double i2) {
        this(branchId, p1, q1, i1, p2, q2, i2, Double.NaN);
    }

    public BranchResult(String branchId, double p1, double q1, double i1, double p2, double q2, double i2, double flowTransfer) {
        this.branchId = Objects.requireNonNull(branchId);
        this.p1 = p1;
        this.q1 = q1;
        this.i1 = i1;
        this.p2 = p2;
        this.q2 = q2;
        this.i2 = i2;
        this.flowTransfer = flowTransfer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BranchResult that = (BranchResult)((Object)o);
        return Double.compare(that.p1, this.p1) == 0 && Double.compare(that.q1, this.q1) == 0 && Double.compare(that.i1, this.i1) == 0 && Double.compare(that.p2, this.p2) == 0 && Double.compare(that.q2, this.q2) == 0 && Double.compare(that.i2, this.i2) == 0 && Objects.equals(this.branchId, that.branchId);
    }

    public int hashCode() {
        return Objects.hash(this.branchId, this.p1, this.q1, this.i1, this.p2, this.q2, this.i2);
    }

    public String getBranchId() {
        return this.branchId;
    }

    public double getI1() {
        return this.i1;
    }

    public double getI2() {
        return this.i2;
    }

    public double getP1() {
        return this.p1;
    }

    public double getP2() {
        return this.p2;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getFlowTransfer() {
        return this.flowTransfer;
    }

    public String toString() {
        return "BranchResult{branchId='" + this.branchId + "', p1=" + this.p1 + ", q1=" + this.q1 + ", i1=" + this.i1 + ", p2=" + this.p2 + ", q2=" + this.q2 + ", i2=" + this.i2 + ", flowTransfer=" + this.flowTransfer + "}";
    }
}

